/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.func;

import java.util.List;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.LazyContinuation;
import org.apache.tapestry5.func.LazyFunction;
import org.apache.tapestry5.func.Mapper;

class Interleaver<T>
implements LazyFunction<T> {
    private final int valueIndex;
    private final List<Flow<T>> flows;

    Interleaver(List<Flow<T>> flows) {
        this(flows, 0);
    }

    private Interleaver(List<Flow<T>> flows, int valueIndex) {
        this.flows = flows;
        this.valueIndex = valueIndex;
    }

    @Override
    public LazyContinuation<T> next() {
        if (this.valueIndex == 0) {
            for (Flow<T> flow : this.flows) {
                if (!flow.isEmpty()) continue;
                return null;
            }
        }
        return new LazyContinuation(this.flows.get(this.valueIndex).first(), this.nextFunction());
    }

    private LazyFunction<T> nextFunction() {
        if (this.valueIndex < this.flows.size() - 1) {
            return new Interleaver<T>(this.flows, this.valueIndex + 1);
        }
        List<Flow<T>> nextFlows = F.flow(this.flows).map(new Mapper<Flow<T>, Flow<T>>(){

            @Override
            public Flow<T> map(Flow<T> element) {
                return (Flow)element.rest();
            }
        }).toList();
        return new Interleaver<T>(nextFlows, 0);
    }
}

