/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.model.JParameter;
import org.ballerinalang.bindgen.utils.BindgenConstants;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JMethod {
    private boolean isStatic;
    private boolean hasParams = true;
    private boolean hasReturn = false;
    private boolean returnError = false;
    private boolean objectReturn = false;
    private boolean reservedWord = false;
    private boolean isArrayReturn = false;
    private boolean hasException = false;
    private boolean handleException = false;
    private boolean isStringReturn = false;
    private boolean javaArraysModule = false;
    private boolean hasPrimitiveParam = false;
    private Method method;
    private String methodName;
    private String returnType;
    private String externalType;
    private String exceptionName;
    private String returnTypeJava;
    private String shortClassName;
    private String javaMethodName;
    private String returnComponentType;
    private String interopType = "@java:Method";
    private List<JParameter> parameters = new ArrayList<JParameter>();
    private StringBuilder paramTypes = new StringBuilder();

    JMethod(Method m) {
        this.method = m;
        this.javaMethodName = m.getName();
        this.methodName = m.getName();
        this.shortClassName = BindgenUtils.getAlias(m.getDeclaringClass());
        this.isStatic = BindgenUtils.isStaticMethod(m);
        Class<?> returnTypeClass = m.getReturnType();
        if (!returnTypeClass.equals(Void.TYPE)) {
            this.setReturnTypeAttributes(returnTypeClass);
        }
        for (Class<?> exceptionType : m.getExceptionTypes()) {
            try {
                if (this.getClass().getClassLoader().loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom(exceptionType)) continue;
                JError jError = new JError(exceptionType);
                this.exceptionName = jError.getShortExceptionName();
                BindingsGenerator.setExceptionList(jError);
                this.hasException = true;
                this.handleException = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.setParameters(m.getParameters());
        if (!this.parameters.isEmpty()) {
            JParameter lastParam = this.parameters.get(this.parameters.size() - 1);
            lastParam.setHasNext(false);
        } else {
            this.hasParams = false;
        }
        List<String> reservedWords = Arrays.asList(BindgenConstants.BALLERINA_RESERVED_WORDS);
        if (reservedWords.contains(this.methodName)) {
            this.reservedWord = true;
        }
        if (this.objectReturn && !BindingsGenerator.getAllJavaClasses().contains(returnTypeClass.getName())) {
            if (this.isArrayReturn) {
                BindingsGenerator.setClassListForLooping(returnTypeClass.getComponentType().getName());
            } else {
                BindingsGenerator.setClassListForLooping(returnTypeClass.getName());
            }
        }
    }

    private void setReturnTypeAttributes(Class returnTypeClass) {
        this.hasReturn = true;
        this.returnTypeJava = BindgenUtils.getJavaType(returnTypeClass);
        this.externalType = BindgenUtils.getBallerinaHandleType(returnTypeClass);
        this.returnType = BindgenUtils.getBallerinaParamType(returnTypeClass);
        this.returnType = this.getExceptionName(returnTypeClass, this.returnType);
        if (returnTypeClass.isArray()) {
            this.javaArraysModule = true;
            this.hasException = true;
            this.returnError = true;
            this.isArrayReturn = true;
            if (returnTypeClass.getComponentType().isPrimitive()) {
                this.objectReturn = false;
            } else if (BindgenUtils.getAlias(returnTypeClass).equals("String[]")) {
                this.objectReturn = false;
            } else {
                this.returnComponentType = BindgenUtils.getAlias(returnTypeClass.getComponentType());
                this.returnComponentType = this.getExceptionName(returnTypeClass.getComponentType(), this.returnComponentType);
                this.objectReturn = true;
            }
        } else if (returnTypeClass.isPrimitive()) {
            this.objectReturn = false;
        } else if (BindgenUtils.getAlias(returnTypeClass).equals("String")) {
            this.isStringReturn = true;
        } else {
            this.objectReturn = true;
        }
    }

    private String getExceptionName(Class exception, String name) {
        try {
            if (this.getClass().getClassLoader().loadClass(Exception.class.getCanonicalName()).isAssignableFrom(exception)) {
                return "J" + name;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return name;
    }

    private void setParameters(Parameter[] paramArr) {
        for (Parameter param : paramArr) {
            this.paramTypes.append(BindgenUtils.getAlias(param.getType()).toLowerCase(Locale.ENGLISH));
            JParameter parameter = new JParameter(param);
            this.parameters.add(parameter);
            if (parameter.getIsPrimitiveArray().booleanValue()) {
                this.javaArraysModule = true;
                this.returnError = true;
                this.hasPrimitiveParam = true;
                this.hasException = true;
            }
            if (!parameter.isObjArrayParam().booleanValue() && !parameter.getIsStringArray().booleanValue()) continue;
            this.javaArraysModule = true;
            this.returnError = true;
            this.hasException = true;
        }
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    String getParamTypes() {
        return this.paramTypes.toString();
    }

    public Boolean getHasReturn() {
        return this.hasReturn;
    }

    public Boolean getHasException() {
        return this.hasException;
    }

    public Boolean getIsStringReturn() {
        return this.isStringReturn;
    }

    public Boolean getHasPrimitiveParam() {
        return this.hasPrimitiveParam;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<JParameter> getParameters() {
        return this.parameters;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean hasParams() {
        return this.hasParams;
    }

    public String getExternalType() {
        return this.externalType;
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public boolean isReturnError() {
        return this.returnError;
    }

    void setShortClassName(String shortClassName) {
        this.shortClassName = shortClassName;
    }

    public Method getMethod() {
        return this.method;
    }

    boolean requireJavaArrays() {
        return this.javaArraysModule;
    }
}

