/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model;

import java.sql.SQLException;
import java.sql.Struct;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableOMDataSource
extends AbstractPushOMDataSource {
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String ARRAY_ELEMENT_NAME = "element";
    private static final String DEFAULT_ROOT_WRAPPER = "results";
    private static final String DEFAULT_ROW_WRAPPER = "result";
    private BTable table;
    private String rootWrapper;
    private String rowWrapper;

    public TableOMDataSource(BTable table, String rootWrapper, String rowWrapper) {
        this.table = table;
        this.rootWrapper = rootWrapper != null ? rootWrapper : DEFAULT_ROOT_WRAPPER;
        this.rowWrapper = rowWrapper != null ? rowWrapper : DEFAULT_ROW_WRAPPER;
    }

    public void serialize(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("", this.rootWrapper, "");
        while (this.table.hasNext()) {
            this.table.moveToNext();
            xmlStreamWriter.writeStartElement("", this.rowWrapper, "");
            BStructureType structType = this.table.getStructType();
            BField[] structFields = null;
            if (structType != null) {
                structFields = structType.getFields().values().toArray(new BField[0]);
            }
            int index = 1;
            for (ColumnDefinition col : this.table.getColumnDefs()) {
                String name = structFields != null ? structFields[index - 1].getFieldName() : col.getName();
                this.writeElement(xmlStreamWriter, name, col.getType(), index, structFields);
                ++index;
            }
            xmlStreamWriter.writeEndElement();
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.flush();
    }

    private void writeElement(XMLStreamWriter xmlStreamWriter, String name, TypeKind type, int index, BField[] structFields) throws XMLStreamException {
        boolean isArray = false;
        xmlStreamWriter.writeStartElement("", name, "");
        String value = null;
        switch (type) {
            case BOOLEAN: {
                value = String.valueOf(this.table.getBoolean(index));
                break;
            }
            case STRING: {
                value = this.table.getString(index);
                break;
            }
            case INT: {
                value = String.valueOf(this.table.getInt(index));
                break;
            }
            case FLOAT: {
                value = String.valueOf(this.table.getFloat(index));
                break;
            }
            case DECIMAL: {
                value = String.valueOf(this.table.getDecimal(index));
                break;
            }
            case BLOB: {
                value = this.table.getBlob(index);
                break;
            }
            case ARRAY: {
                isArray = true;
                Object[] array = this.table.getArray(index);
                this.processArray(xmlStreamWriter, array);
                break;
            }
            case OBJECT: 
            case RECORD: {
                isArray = true;
                Object[] structData = this.table.getStruct(index);
                if (structFields == null) {
                    this.processArray(xmlStreamWriter, structData);
                    break;
                }
                this.processStruct(xmlStreamWriter, structData, structFields, index);
                break;
            }
            default: {
                value = this.table.getString(index);
            }
        }
        if (!isArray) {
            if (value == null) {
                xmlStreamWriter.writeNamespace(XSI_PREFIX, XSI_NAMESPACE);
                xmlStreamWriter.writeAttribute(XSI_PREFIX, XSI_NAMESPACE, "nil", "true");
            } else {
                xmlStreamWriter.writeCharacters(value);
            }
        }
        xmlStreamWriter.writeEndElement();
    }

    private void processArray(XMLStreamWriter xmlStreamWriter, Object[] array) throws XMLStreamException {
        if (array != null) {
            for (Object value : array) {
                xmlStreamWriter.writeStartElement("", ARRAY_ELEMENT_NAME, "");
                xmlStreamWriter.writeCharacters(String.valueOf(value));
                xmlStreamWriter.writeEndElement();
            }
        }
    }

    private void processStruct(XMLStreamWriter xmlStreamWriter, Object[] structData, BField[] structFields, int index) throws XMLStreamException {
        try {
            BField[] internalStructFields;
            int i = 0;
            boolean structError = true;
            BType internaltType = structFields[index - 1].fieldType;
            if ((internaltType.getTag() == 32 || internaltType.getTag() == 12) && (internalStructFields = ((BStructureType)internaltType).getFields().values().toArray(new BField[0])) != null) {
                for (Object val : structData) {
                    xmlStreamWriter.writeStartElement("", internalStructFields[i].fieldName, "");
                    if (val instanceof Struct) {
                        this.processStruct(xmlStreamWriter, ((Struct)val).getAttributes(), internalStructFields, i + 1);
                    } else {
                        xmlStreamWriter.writeCharacters(val.toString());
                    }
                    xmlStreamWriter.writeEndElement();
                    ++i;
                }
                structError = false;
            }
            if (structError) {
                throw new BallerinaException("error in constructing the xml element from struct type data");
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in retrieving struct data to construct the inner xml element:" + e.getMessage());
        }
    }

    public boolean isDestructiveWrite() {
        return true;
    }
}

