/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import org.ballerinalang.model.types.BIndexedType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.wso2.ballerinalang.compiler.util.BArrayState;

public class BArrayType
extends BType
implements BIndexedType {
    private BType elementType;
    private int dimensions = 1;
    private int size = -1;
    private BArrayState state = BArrayState.UNSEALED;

    public BArrayType(BType elementType) {
        super(null, null, BNewArray.class);
        this.elementType = elementType;
        if (elementType instanceof BArrayType) {
            this.dimensions = ((BArrayType)elementType).getDimensions() + 1;
        }
    }

    public BArrayType(BType elemType, int size) {
        super(null, null, BNewArray.class);
        this.elementType = elemType;
        if (this.elementType instanceof BArrayType) {
            this.dimensions = ((BArrayType)this.elementType).getDimensions() + 1;
        }
        if (size != -1) {
            this.state = BArrayState.CLOSED_SEALED;
            this.size = size;
        }
    }

    @Override
    public BType getElementType() {
        return this.elementType;
    }

    @Override
    public <V extends BValue> V getZeroValue() {
        if (this.size != -1) {
            int tag = this.elementType.getTag();
            switch (tag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return (V)new BValueArray(this.elementType, this.size);
                }
            }
            return (V)new BValueArray(this);
        }
        return this.getEmptyValue();
    }

    @Override
    public <V extends BValue> V getEmptyValue() {
        int tag = this.elementType.getTag();
        switch (tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return (V)new BValueArray(this.elementType);
            }
        }
        return (V)new BValueArray(this);
    }

    @Override
    public int getTag() {
        return 19;
    }

    @Override
    public int hashCode() {
        return super.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BArrayType) {
            BArrayType other = (BArrayType)obj;
            if (other.state == BArrayState.CLOSED_SEALED && this.size != other.size) {
                return false;
            }
            return this.elementType.equals(other.elementType);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.elementType.toString());
        if (sb.indexOf("[") != -1) {
            return this.size != -1 ? sb.insert(sb.indexOf("["), "[" + this.size + "]").toString() : sb.insert(sb.indexOf("["), "[]").toString();
        }
        return this.size != -1 ? sb.append("[").append(this.size).append("]").toString() : sb.append("[]").toString();
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int getSize() {
        return this.size;
    }

    public BArrayState getState() {
        return this.state;
    }
}

