/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import java.util.ArrayList;
import java.util.Arrays;
import org.ballerinalang.model.types.BAnyType;
import org.ballerinalang.model.types.BAnydataType;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BBooleanType;
import org.ballerinalang.model.types.BByteType;
import org.ballerinalang.model.types.BChannelType;
import org.ballerinalang.model.types.BDecimalType;
import org.ballerinalang.model.types.BErrorType;
import org.ballerinalang.model.types.BFloatType;
import org.ballerinalang.model.types.BFutureType;
import org.ballerinalang.model.types.BHandleType;
import org.ballerinalang.model.types.BIntegerType;
import org.ballerinalang.model.types.BIteratorType;
import org.ballerinalang.model.types.BJSONType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BNullType;
import org.ballerinalang.model.types.BServiceType;
import org.ballerinalang.model.types.BStreamType;
import org.ballerinalang.model.types.BStringType;
import org.ballerinalang.model.types.BTableType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypeDesc;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.types.BXMLType;

public class BTypes {
    public static BType typeInt = new BIntegerType("int", null);
    public static BType typeByte = new BByteType("byte", null);
    public static BType typeFloat = new BFloatType("float", null);
    public static BType typeDecimal = new BDecimalType("decimal", null);
    public static BType typeString = new BStringType("string", null);
    public static BType typeBoolean = new BBooleanType("boolean", null);
    public static BType typeXML = new BXMLType("xml", null);
    public static BType typeJSON = new BJSONType("json", null);
    public static BType typeTable = new BTableType("table", null);
    public static BType typeAny = new BAnyType("any", null);
    public static BType typeAnydata = new BAnydataType("anydata", null);
    public static BType typeStream = new BStreamType("stream", typeAny, null);
    public static BType typeDesc = new BTypeDesc("typedesc", null);
    public static BType typeMap = new BMapType("map", typeAny, null);
    public static BType typeFuture = new BFutureType("future", null);
    public static BType typeNull = new BNullType("null", null);
    public static BType typeIterator = new BIteratorType("iterator", null);
    public static BType typeChannel = new BChannelType("channel", null);
    public static BErrorType typeError = new BErrorType("error", typeString, typeMap, null);
    public static BType typeAnyService = new BServiceType("service", null, 0);
    public static BType typePureType = new BUnionType(new ArrayList<BType>(Arrays.asList(typeAnydata, typeError)));
    public static BType typeHandle = new BHandleType("handle", null, null);

    private BTypes() {
    }

    public static boolean isValueType(BType type) {
        return type == typeInt || type == typeByte || type == typeFloat || type == typeDecimal || type == typeString || type == typeBoolean;
    }

    public static BType getTypeFromName(String typeName) {
        switch (typeName) {
            case "int": {
                return typeInt;
            }
            case "byte": {
                return typeByte;
            }
            case "float": {
                return typeFloat;
            }
            case "decimal": {
                return typeDecimal;
            }
            case "string": {
                return typeString;
            }
            case "boolean": {
                return typeBoolean;
            }
            case "json": {
                return typeJSON;
            }
            case "xml": {
                return typeXML;
            }
            case "map": {
                return typeMap;
            }
            case "future": {
                return typeFuture;
            }
            case "table": {
                return typeTable;
            }
            case "stream": {
                return typeStream;
            }
            case "channel": {
                return typeChannel;
            }
            case "any": {
                return typeAny;
            }
            case "typedesc": {
                return typeDesc;
            }
            case "null": {
                return typeNull;
            }
            case "error": {
                return typeError;
            }
            case "anydata": {
                return typeAnydata;
            }
        }
        throw new IllegalStateException("Unknown type name");
    }

    public static BType fromString(String typeName) {
        if (typeName.endsWith("[]")) {
            String elementTypeName = typeName.substring(0, typeName.length() - 2);
            BType elemType = BTypes.fromString(elementTypeName);
            return new BArrayType(elemType);
        }
        return BTypes.getTypeFromName(typeName);
    }

    static {
        BTypes.typeError.detailType = new BMapType(typePureType);
    }
}

