/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer.providers.bvalue;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BString;

public class NumericBValueProviders {
    private NumericBValueProviders() {
    }

    public static class BigDecimalBValueProvider
    implements SerializationBValueProvider<BigDecimal> {
        static final String BIG_DEC = BigDecimal.class.getName();

        @Override
        public String typeName() {
            return BIG_DEC;
        }

        @Override
        public Class<?> getType() {
            return BigDecimal.class;
        }

        @Override
        public BPacket toBValue(BigDecimal bigDecimal, BValueSerializer serializer) {
            return BPacket.from(BIG_DEC, new BString(bigDecimal.toString()));
        }

        @Override
        public BigDecimal toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            String payload = packet.getValue().stringValue();
            return new BigDecimal(payload);
        }
    }

    public static class BigIntegerBValueProvider
    implements SerializationBValueProvider<BigInteger> {
        static final String BIG_INT = BigInteger.class.getName();

        @Override
        public String typeName() {
            return BIG_INT;
        }

        @Override
        public Class<?> getType() {
            return BigInteger.class;
        }

        @Override
        public BPacket toBValue(BigInteger bigInteger, BValueSerializer serializer) {
            return BPacket.from(BIG_INT, new BString(bigInteger.toString(10)));
        }

        @Override
        public BigInteger toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            String payload = packet.getValue().stringValue();
            return new BigInteger(payload, 10);
        }
    }
}

