/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.Flags;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BMap<K, V extends BValue>
implements BRefType,
BCollection {
    private LinkedHashMap<K, V> map;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private BType type = BTypes.typeMap;
    private HashMap<String, Object> nativeData = new HashMap();

    public BMap() {
        this.map = new LinkedHashMap();
    }

    public BMap(BType type) {
        this.map = new LinkedHashMap();
        this.type = type;
    }

    public V get(K key) {
        this.readLock.lock();
        try {
            BValue bValue = (BValue)this.map.get(key);
            return (V)bValue;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public V getIfExist(K key) {
        this.readLock.lock();
        try {
            if (!this.map.containsKey(key)) {
                throw new BallerinaException("cannot find key '" + key + "'");
            }
            BValue bValue = (BValue)this.map.get(key);
            return (V)bValue;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, boolean except) {
        this.readLock.lock();
        try {
            if (!this.map.containsKey(key) && except) {
                throw new BallerinaException(BallerinaErrorReasons.KEY_NOT_FOUND_ERROR, "cannot find key '" + key + "'");
            }
            BValue bValue = (BValue)this.map.get(key);
            return (V)bValue;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void put(K key, V value) {
        this.writeLock.lock();
        try {
            this.map.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasKey(K key) {
        this.readLock.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public LinkedHashMap<K, V> getMap() {
        return this.map;
    }

    @Override
    public long size() {
        this.readLock.lock();
        try {
            long l = this.map.size();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        this.writeLock.lock();
        try {
            boolean hasKey = this.map.containsKey(key);
            if (hasKey) {
                this.map.remove(key);
            }
            boolean bl = hasKey;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public K[] keys() {
        this.readLock.lock();
        try {
            Set<K> keys = this.map.keySet();
            Object[] objectArray = keys.toArray(new String[keys.size()]);
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public V[] values() {
        this.readLock.lock();
        try {
            Collection<V> values = this.map.values();
            BValue[] bValueArray = values.toArray(new BRefType[values.size()]);
            return bValueArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.map.size() == 0;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Object value() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stringValue() {
        this.readLock.lock();
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        try {
            switch (this.type.getTag()) {
                case 32: {
                    for (Map.Entry<String, BField> field : ((BStructureType)this.type).getFields().entrySet()) {
                        if (!Flags.isFlagOn(field.getValue().flags, 1)) continue;
                        String fieldName = field.getKey();
                        V fieldVal = this.get(fieldName);
                        sj.add(fieldName + ":" + this.getStringValue(fieldVal));
                    }
                    break;
                }
                case 7: {
                    String string = this.getJSONString();
                    return string;
                }
                case 15: {
                    if (((BMapType)this.type).getConstrainedType().getTag() == 7) {
                        String string = this.getJSONString();
                        return string;
                    }
                }
                default: {
                    String keySeparator = this.type.getTag() == 15 ? "\"" : "";
                    for (Map.Entry<K, V> e : this.map.entrySet()) {
                        String key = keySeparator + e.getKey() + keySeparator;
                        BValue value = (BValue)e.getValue();
                        sj.add(key + ":" + this.getStringValue(value));
                    }
                }
            }
            String string = sj.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String absoluteStringValue() {
        this.readLock.lock();
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        try {
            switch (this.type.getTag()) {
                case 32: {
                    ((BStructureType)this.type).getFields().forEach((fieldName, field) -> {
                        V fieldVal = this.get(fieldName);
                        sj.add(fieldName + ":" + this.getStringValue(fieldVal));
                    });
                    break;
                }
                case 7: {
                    String string = this.getJSONString();
                    return string;
                }
                default: {
                    String keySeparator = this.type.getTag() == 15 ? "\"" : "";
                    this.map.forEach((mapKey, value) -> {
                        String key = keySeparator + mapKey + keySeparator;
                        sj.add(key + ":" + this.getStringValue(value));
                    });
                }
            }
            String string = sj.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public BType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        this.readLock.lock();
        try {
            if (this.isFrozen()) {
                BMap bMap = this;
                return bMap;
            }
            if (refs.containsKey(this)) {
                BValue bValue = refs.get(this);
                return bValue;
            }
            BMap<K, BValue> newMap = new BMap<K, BValue>(this.type);
            refs.put(this, newMap);
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                BValue value = (BValue)entry.getValue();
                newMap.put(entry.getKey(), value == null ? null : value.copy(refs));
            }
            BMap<K, BValue> bMap = newMap;
            return bMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public BIterator newIterator() {
        return new BMapIterator(this);
    }

    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    public String toString() {
        return this.stringValue();
    }

    public HashMap<String, Object> getNativeData() {
        return this.nativeData;
    }

    @Override
    public synchronized boolean isFrozen() {
        return true;
    }

    private String getStringValue(V value) {
        try {
            if (value == null) {
                return "()";
            }
            if (value instanceof BString) {
                return "\"" + value.stringValue() + "\"";
            }
            return value.stringValue();
        }
        catch (StackOverflowError e) {
            return "{StackOverFlowError}";
        }
    }

    private String getJSONString() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        JsonGenerator gen = new JsonGenerator(byteOut);
        try {
            gen.serialize(this);
            gen.flush();
        }
        catch (IOException e) {
            throw new BallerinaException("Error in converting JSON to a string: " + e.getMessage(), e);
        }
        return new String(byteOut.toByteArray());
    }

    static class BMapIterator<K, V extends BValue>
    implements BIterator {
        BMap<K, V> collection;
        Iterator<Map.Entry<K, V>> iterator;
        long cursor = 0L;

        BMapIterator(BMap<K, V> value) {
            this.collection = value;
            this.iterator = new LinkedHashMap(((BMap)value).map).entrySet().iterator();
        }

        @Override
        public BValue getNext() {
            if (this.cursor++ == this.collection.size()) {
                return null;
            }
            LinkedList<BType> types = new LinkedList<BType>();
            types.add(BTypes.typeString);
            types.add(BTypes.typeAny);
            BTupleType tupleType = new BTupleType(types);
            Map.Entry<K, V> next = this.iterator.next();
            BValueArray tuple = new BValueArray(tupleType);
            BString key = new BString((String)next.getKey());
            tuple.add(0L, key);
            BRefType value = (BRefType)next.getValue();
            tuple.add(1L, value);
            return tuple;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.collection.size() && this.iterator.hasNext();
        }
    }
}

