/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.TableIterator;
import org.ballerinalang.util.TableResourceManager;
import org.ballerinalang.util.TableUtils;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableProvider {
    private static TableProvider tableProvider = null;
    private int tableID = 99999;
    private int indexID = 99999;

    private TableProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableProvider getInstance() {
        if (tableProvider != null) {
            return tableProvider;
        }
        Class<TableProvider> clazz = TableProvider.class;
        synchronized (TableProvider.class) {
            if (tableProvider == null) {
                tableProvider = new TableProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tableProvider;
        }
    }

    private synchronized int getTableID() {
        return this.tableID++;
    }

    private synchronized int getIndexID() {
        return this.indexID++;
    }

    public String createTable(BType constrainedType, BValueArray primaryKeys, BValueArray indexeColumns) {
        String tableName = "TABLE_" + constrainedType.getName().toUpperCase() + "_" + this.getTableID();
        String sqlStmt = this.generateCreateTableStatment(tableName, constrainedType, primaryKeys);
        this.executeStatement(sqlStmt);
        if (indexeColumns != null) {
            this.generateIndexesForTable(tableName, indexeColumns);
        }
        return tableName;
    }

    public String createTable(String fromTableName, String joinTableName, String query, BStructureType tableType, BValueArray params) {
        String newTableName = "TABLE_" + tableType.getName().toUpperCase() + "_" + this.getTableID();
        String sqlStmt = query.replaceFirst("\\[\\[tableName\\]\\]", fromTableName);
        if (joinTableName != null && !joinTableName.isEmpty()) {
            sqlStmt = sqlStmt.replaceFirst("\\[\\[tableName\\]\\]", joinTableName);
        }
        sqlStmt = this.generateCreateTableStatment(sqlStmt, newTableName);
        this.prepareAndExecuteStatement(sqlStmt, params);
        return newTableName;
    }

    public String createTable(String fromTableName, String query, BStructureType tableType, BValueArray params) {
        return this.createTable(fromTableName, null, query, tableType, params);
    }

    public void insertData(String tableName, BMap<String, BValue> constrainedType) {
        String sqlStmt = TableUtils.generateInsertDataStatment(tableName, constrainedType);
        this.prepareAndExecuteStatement(sqlStmt, constrainedType);
    }

    public void deleteData(String tableName, BMap<String, BValue> constrainedType) {
        String sqlStmt = TableUtils.generateDeleteDataStatment(tableName, constrainedType);
        this.prepareAndExecuteStatement(sqlStmt, constrainedType);
    }

    public void dropTable(String tableName) {
        String sqlStmt = "DROP TABLE " + tableName;
        this.executeStatement(sqlStmt);
    }

    public TableIterator createIterator(String tableName, BStructureType type) {
        TableIterator itr;
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
            TableResourceManager rm = new TableResourceManager(conn, stmt, true);
            rm.addResultSet(rs);
            itr = new TableIterator(rm, rs, type);
        }
        catch (SQLException e) {
            this.releaseResources(conn, stmt);
            throw new BallerinaException("error in creating iterator for table : " + e.getMessage());
        }
        return itr;
    }

    private Connection getConnection() {
        Connection conn;
        try {
            conn = DriverManager.getConnection("jdbc:h2:mem:TABLEDB;DB_CLOSE_DELAY=-1", "sa", "");
        }
        catch (SQLException e) {
            throw new BallerinaException("error in gettign connection for table db : " + e.getMessage());
        }
        return conn;
    }

    private String generateCreateTableStatment(String tableName, BType constrainedType, BValueArray primaryKeys) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(tableName).append(" (");
        Collection<BField> structFields = ((BStructureType)constrainedType).getFields().values();
        String seperator = "";
        for (BField sf : structFields) {
            int type = sf.getFieldType().getTag();
            String name = sf.getFieldName();
            sb.append(seperator).append(name).append(" ");
            switch (type) {
                case 1: {
                    sb.append("BIGINT");
                    break;
                }
                case 5: {
                    sb.append("VARCHAR");
                    break;
                }
                case 3: 
                case 4: {
                    sb.append("DOUBLE");
                    break;
                }
                case 6: {
                    sb.append("BOOLEAN");
                    break;
                }
                case 7: 
                case 8: {
                    sb.append("CLOB");
                    break;
                }
                case 19: {
                    BType elementType = ((BArrayType)sf.getFieldType()).getElementType();
                    if (elementType.getTag() == 2) {
                        sb.append("BLOB");
                        break;
                    }
                    sb.append("ARRAY");
                    break;
                }
                default: {
                    throw new BallerinaException("Unsupported column type for table : " + sf.getFieldType());
                }
            }
            seperator = ",";
        }
        if (primaryKeys != null) {
            seperator = "";
            int primaryKeyCount = (int)primaryKeys.size();
            if (primaryKeyCount > 0) {
                sb.append(",PRIMARY KEY (");
                for (int i = 0; i < primaryKeyCount; ++i) {
                    sb.append(seperator).append(primaryKeys.getString(i));
                    seperator = ",";
                }
                sb.append(")");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private String generateCreateTableStatment(String query, String newTableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(newTableName).append(" ").append("AS ");
        sb.append(query);
        return sb.toString();
    }

    private void generateIndexesForTable(String tableName, BValueArray indexColumns) {
        int indexCount = (int)indexColumns.size();
        if (indexCount > 0) {
            for (int i = 0; i < indexCount; ++i) {
                StringBuilder sb = new StringBuilder();
                String columnName = indexColumns.getString(i);
                sb.append("CREATE INDEX ").append("IDX_").append(columnName).append(this.getIndexID()).append(" ON ").append(tableName).append("(").append(columnName).append(")");
                this.executeStatement(sb.toString());
            }
        }
    }

    private void executeStatement(String queryStatement) {
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(queryStatement);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void prepareAndExecuteStatement(String queryStatement, BValueArray params) {
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(queryStatement);
            int index = 1;
            while ((long)index <= params.size()) {
                BRefType<?> param = params.getRefValue(index - 1);
                switch (param.getType().getTag()) {
                    case 1: {
                        stmt.setLong(index, (Long)param.value());
                        break;
                    }
                    case 5: {
                        stmt.setString(index, (String)param.value());
                        break;
                    }
                    case 3: {
                        stmt.setDouble(index, (Double)param.value());
                        break;
                    }
                    case 6: {
                        stmt.setBoolean(index, (Boolean)param.value());
                        break;
                    }
                    case 7: 
                    case 8: {
                        stmt.setString(index, (String)param.value());
                        break;
                    }
                    case 19: {
                        BType elementType = ((BArrayType)param.getType()).getElementType();
                        if (elementType.getTag() == 2) {
                            byte[] blobData = (byte[])param.value();
                            stmt.setBlob(index, new ByteArrayInputStream(blobData), blobData.length);
                            break;
                        }
                        Object[] arrayData = TableUtils.getArrayData(param);
                        stmt.setObject(index, arrayData);
                    }
                }
                ++index;
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BallerinaException("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void prepareAndExecuteStatement(String queryStatement, BMap<String, BValue> constrainedType) {
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(queryStatement);
            TableUtils.prepareAndExecuteStatement(stmt, constrainedType);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void releaseResources(Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in releasing table statement resource : " + e.getMessage());
        }
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in releasing table connection resource : " + e.getMessage());
        }
    }

    public int getRowCount(String tableName) {
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
            int rowCount = 0;
            if (rs.next()) {
                rowCount = rs.getInt(1);
            }
            int n = rowCount;
            return n;
        }
        catch (SQLException e) {
            throw new BallerinaException("error in executing statement to get the count : " + stmt + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }
}

