/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class DataContext {
    private Strand strand = null;
    private HttpClientConnector clientConnector = null;
    private ObjectValue requestObj = null;
    private NonBlockingCallback callback = null;
    private HttpCarbonMessage correlatedMessage;

    public DataContext(Strand strand, HttpClientConnector clientConnector, NonBlockingCallback callback, ObjectValue requestObj, HttpCarbonMessage outboundRequestMsg) {
        this.strand = strand;
        this.callback = callback;
        this.clientConnector = clientConnector;
        this.requestObj = requestObj;
        this.correlatedMessage = outboundRequestMsg;
    }

    public DataContext(Strand strand, NonBlockingCallback callback, HttpCarbonMessage inboundRequestMsg) {
        this.strand = strand;
        this.callback = callback;
        this.clientConnector = null;
        this.requestObj = null;
        this.correlatedMessage = inboundRequestMsg;
    }

    public void notifyInboundResponseStatus(ObjectValue inboundResponse, ErrorValue httpConnectorError) {
        if (inboundResponse != null) {
            this.getCallback().setReturnValues((Object)inboundResponse);
        } else if (httpConnectorError != null) {
            this.getCallback().setReturnValues((Object)httpConnectorError);
        } else {
            MapValue err = BallerinaValues.createRecordValue((BPackage)BLangConstants.BALLERINA_BUILTIN_PKG_ID, (String)"error");
            this.getCallback().setReturnValues((Object)err);
        }
        this.getCallback().notifySuccess();
    }

    public void notifyOutboundResponseStatus(ErrorValue httpConnectorError) {
        if (httpConnectorError == null) {
            this.getCallback().setReturnValues(null);
        } else {
            this.getCallback().setReturnValues((Object)httpConnectorError);
        }
        this.getCallback().notifySuccess();
    }

    public HttpCarbonMessage getOutboundRequest() {
        return this.correlatedMessage;
    }

    public HttpClientConnector getClientConnector() {
        return this.clientConnector;
    }

    public ObjectValue getRequestObj() {
        return this.requestObj;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public NonBlockingCallback getCallback() {
        return this.callback;
    }
}

