/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.langlib.typedesc.ConstructFrom;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpResourceArguments;
import org.ballerinalang.net.http.HttpResourceDispatcher;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.SignatureParams;
import org.ballerinalang.net.http.ValueCreatorUtils;
import org.ballerinalang.net.uri.URIUtil;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpDispatcher {
    public static HttpService findService(HTTPServicesRegistry servicesRegistry, HttpCarbonMessage inboundReqMsg) {
        try {
            List<String> sortedServiceURIs;
            Map<String, HttpService> servicesOnInterface;
            String hostName = inboundReqMsg.getHeader(HttpHeaderNames.HOST.toString());
            if (hostName != null && servicesRegistry.getServicesMapHolder(hostName) != null) {
                servicesOnInterface = servicesRegistry.getServicesByHost(hostName);
                sortedServiceURIs = servicesRegistry.getSortedServiceURIsByHost(hostName);
            } else if (servicesRegistry.getServicesMapHolder("b7a.default") != null) {
                servicesOnInterface = servicesRegistry.getServicesByHost("b7a.default");
                sortedServiceURIs = servicesRegistry.getSortedServiceURIsByHost("b7a.default");
            } else {
                inboundReqMsg.setHttpStatusCode(Integer.valueOf(404));
                String localAddress = inboundReqMsg.getProperty("LOCAL_ADDRESS").toString();
                throw new BallerinaConnectorException("no service has registered for listener : " + localAddress);
            }
            String rawUri = (String)inboundReqMsg.getProperty("TO");
            inboundReqMsg.setProperty("RAW_URI", (Object)rawUri);
            HashMap<String, Map<String, String>> matrixParams = new HashMap<String, Map<String, String>>();
            String uriWithoutMatrixParams = URIUtil.extractMatrixParams(rawUri, matrixParams);
            inboundReqMsg.setProperty("TO", (Object)uriWithoutMatrixParams);
            inboundReqMsg.setProperty("MATRIX_PARAMS", matrixParams);
            String[] rawPathAndQuery = new String[2];
            String[] splittedUri = uriWithoutMatrixParams.split("\\?");
            rawPathAndQuery[0] = splittedUri[0];
            rawPathAndQuery[1] = splittedUri.length > 1 ? splittedUri[1] : "";
            String basePath = servicesRegistry.findTheMostSpecificBasePath(rawPathAndQuery[0], servicesOnInterface, sortedServiceURIs);
            if (basePath == null) {
                inboundReqMsg.setHttpStatusCode(Integer.valueOf(404));
                throw new BallerinaConnectorException("no matching service found for path : " + rawPathAndQuery[0]);
            }
            HttpService service = servicesOnInterface.get(basePath);
            HttpDispatcher.setInboundReqProperties(inboundReqMsg, rawPathAndQuery[0], basePath, rawPathAndQuery[1]);
            return service;
        }
        catch (Exception e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
    }

    private static void setInboundReqProperties(HttpCarbonMessage inboundReqMsg, String rawPath, String basePath, String rawQuery) {
        String subPath = URIUtil.getSubPath(rawPath, basePath);
        inboundReqMsg.setProperty("BASE_PATH", (Object)basePath);
        inboundReqMsg.setProperty("SUB_PATH", (Object)subPath);
        inboundReqMsg.setProperty("QUERY_STR", (Object)rawQuery);
        inboundReqMsg.setProperty("RAW_QUERY_STR", (Object)rawQuery);
    }

    public static URI getValidatedURI(String uriStr) {
        URI requestUri;
        try {
            requestUri = URI.create(uriStr);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        return requestUri;
    }

    public static HttpResource findResource(HTTPServicesRegistry servicesRegistry, HttpCarbonMessage inboundMessage) {
        String protocol = (String)inboundMessage.getProperty("PROTOCOL");
        if (protocol == null) {
            throw new BallerinaConnectorException("protocol not defined in the incoming request");
        }
        try {
            HttpService service = HttpDispatcher.findService(servicesRegistry, inboundMessage);
            if (service == null) {
                throw new BallerinaConnectorException("no Service found to handle the service request");
            }
            return HttpResourceDispatcher.findResource(service, inboundMessage);
        }
        catch (Exception e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
    }

    public static Object[] getSignatureParameters(HttpResource httpResource, HttpCarbonMessage httpCarbonMessage, MapValue endpointConfig) {
        ObjectValue httpCaller = ValueCreatorUtils.createCallerObject();
        ObjectValue inRequest = ValueCreatorUtils.createRequestObject();
        ObjectValue inRequestEntity = ValueCreatorUtils.createEntityObject();
        HttpUtil.enrichHttpCallerWithConnectionInfo(httpCaller, httpCarbonMessage, httpResource, endpointConfig);
        HttpUtil.enrichHttpCallerWithNativeData(httpCaller, httpCarbonMessage, endpointConfig);
        HttpUtil.populateInboundRequest(inRequest, inRequestEntity, httpCarbonMessage);
        SignatureParams signatureParams = httpResource.getSignatureParams();
        Object[] paramValues = new Object[signatureParams.getParamCount() * 2];
        int paramIndex = 0;
        paramValues[paramIndex++] = httpCaller;
        paramValues[paramIndex++] = true;
        paramValues[paramIndex++] = inRequest;
        paramValues[paramIndex] = true;
        if (signatureParams.getParamCount() == 2) {
            return paramValues;
        }
        HttpResourceArguments resourceArgumentValues = (HttpResourceArguments)httpCarbonMessage.getProperty("RESOURCE_ARGS");
        MapValue pathParamOrder = HttpResource.getPathParamOrderMap(httpResource.getBalResource());
        for (Object paramName : pathParamOrder.getKeys()) {
            String argumentValue = resourceArgumentValues.getMap().get(paramName.toString());
            try {
                argumentValue = URLDecoder.decode(argumentValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            int actualSignatureParamIndex = ((Long)pathParamOrder.get(paramName)).intValue();
            paramIndex = actualSignatureParamIndex * 2;
            BType signatureParamType = signatureParams.getPathParamTypes().get(actualSignatureParamIndex - 2);
            try {
                switch (signatureParamType.getTag()) {
                    case 1: {
                        paramValues[paramIndex++] = Long.parseLong(argumentValue);
                        break;
                    }
                    case 3: {
                        paramValues[paramIndex++] = Double.parseDouble(argumentValue);
                        break;
                    }
                    case 6: {
                        paramValues[paramIndex++] = Boolean.parseBoolean(argumentValue);
                        break;
                    }
                    default: {
                        paramValues[paramIndex++] = argumentValue;
                    }
                }
                paramValues[paramIndex] = true;
            }
            catch (Exception ex) {
                throw new BallerinaConnectorException("Error in casting path param : " + ex.getMessage());
            }
        }
        if (signatureParams.getEntityBody() == null) {
            return paramValues;
        }
        try {
            paramValues[paramValues.length - 2] = HttpDispatcher.populateAndGetEntityBody(inRequest, inRequestEntity, signatureParams.getEntityBody());
            paramValues[paramValues.length - 1] = true;
        }
        catch (Exception ex) {
            httpCarbonMessage.setHttpStatusCode(Integer.valueOf(Integer.parseInt("400")));
            throw new BallerinaConnectorException("data binding failed: " + ex.getMessage());
        }
        return paramValues;
    }

    private static Object populateAndGetEntityBody(ObjectValue inRequest, ObjectValue inRequestEntity, BType entityBodyType) throws IOException {
        HttpUtil.populateEntityBody(inRequest, inRequestEntity, true, true);
        try {
            switch (entityBodyType.getTag()) {
                case 5: {
                    String stringDataSource = EntityBodyHandler.constructStringDataSource((ObjectValue)inRequestEntity);
                    EntityBodyHandler.addMessageDataSource((ObjectValue)inRequestEntity, (Object)stringDataSource);
                    return stringDataSource;
                }
                case 7: {
                    Object bjson = EntityBodyHandler.constructJsonDataSource((ObjectValue)inRequestEntity);
                    EntityBodyHandler.addJsonMessageDataSource((ObjectValue)inRequestEntity, (Object)bjson);
                    return bjson;
                }
                case 8: {
                    XMLValue bxml = EntityBodyHandler.constructXmlDataSource((ObjectValue)inRequestEntity);
                    EntityBodyHandler.addMessageDataSource((ObjectValue)inRequestEntity, (Object)bxml);
                    return bxml;
                }
                case 20: {
                    if (((BArrayType)entityBodyType).getElementType().getTag() == 2) {
                        ArrayValue blobDataSource = EntityBodyHandler.constructBlobDataSource((ObjectValue)inRequestEntity);
                        EntityBodyHandler.addMessageDataSource((ObjectValue)inRequestEntity, (Object)blobDataSource);
                        return blobDataSource;
                    }
                    if (((BArrayType)entityBodyType).getElementType().getTag() == 12) {
                        return HttpDispatcher.getRecordEntity(inRequestEntity, entityBodyType);
                    }
                    throw new BallerinaConnectorException("Incompatible Element type found inside an array " + ((BArrayType)entityBodyType).getElementType().getName());
                }
                case 12: {
                    return HttpDispatcher.getRecordEntity(inRequestEntity, entityBodyType);
                }
            }
        }
        catch (ErrorValue ex) {
            throw new BallerinaConnectorException(ex.toString());
        }
        return null;
    }

    private static Object getRecordEntity(ObjectValue inRequestEntity, BType entityBodyType) {
        Object result = HttpDispatcher.getRecord(entityBodyType, HttpDispatcher.getBJsonValue(inRequestEntity));
        if (result instanceof ErrorValue) {
            throw (ErrorValue)((Object)result);
        }
        return result;
    }

    private static Object getRecord(BType entityBodyType, Object bjson) {
        try {
            return ConstructFrom.convert((BType)entityBodyType, (Object)bjson);
        }
        catch (NullPointerException ex) {
            throw new BallerinaConnectorException("cannot convert payload to record type: " + entityBodyType.getName());
        }
    }

    private static Object getBJsonValue(ObjectValue inRequestEntity) {
        Object bjson = EntityBodyHandler.constructJsonDataSource((ObjectValue)inRequestEntity);
        EntityBodyHandler.addJsonMessageDataSource((ObjectValue)inRequestEntity, (Object)bjson);
        return bjson;
    }

    public static boolean shouldDiffer(HttpResource httpResource) {
        return httpResource != null && httpResource.getSignatureParams().getEntityBody() != null;
    }

    private HttpDispatcher() {
    }
}

