/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.ballerinalang.net.uri.parser.DataElement;
import org.ballerinalang.net.uri.parser.DataReturnAgent;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpResourceDataElement
implements DataElement<HttpResource, HttpCarbonMessage> {
    private List<HttpResource> resource;
    private boolean isFirstTraverse = true;
    private boolean hasData = false;

    @Override
    public boolean hasData() {
        return this.hasData;
    }

    @Override
    public void setData(HttpResource newResource) {
        if (this.isFirstTraverse) {
            this.resource = new ArrayList<HttpResource>();
            this.resource.add(newResource);
            this.isFirstTraverse = false;
            this.hasData = true;
            return;
        }
        List<String> newMethods = newResource.getMethods();
        if (newMethods == null) {
            for (HttpResource previousResource : this.resource) {
                if (previousResource.getMethods() != null) continue;
                throw HttpUtil.createHttpError("Two resources have the same addressable URI, " + previousResource.getName() + " and " + newResource.getName(), HttpErrorType.GENERIC_LISTENER_ERROR);
            }
            this.resource.add(newResource);
            this.hasData = true;
            return;
        }
        this.resource.forEach(r -> {
            for (String newMethod : newMethods) {
                if (!DispatcherUtil.isMatchingMethodExist(r, newMethod)) continue;
                throw HttpUtil.createHttpError("Two resources have the same addressable URI, " + r.getName() + " and " + newResource.getName(), HttpErrorType.GENERIC_LISTENER_ERROR);
            }
        });
        this.resource.add(newResource);
        this.hasData = true;
    }

    @Override
    public boolean getData(HttpCarbonMessage carbonMessage, DataReturnAgent<HttpResource> dataReturnAgent) {
        try {
            if (this.resource == null) {
                return false;
            }
            HttpResource httpResource = this.validateHTTPMethod(this.resource, carbonMessage);
            if (httpResource == null) {
                return this.isOptionsRequest(carbonMessage);
            }
            this.validateConsumes(httpResource, carbonMessage);
            this.validateProduces(httpResource, carbonMessage);
            dataReturnAgent.setData(httpResource);
            return true;
        }
        catch (BallerinaException e) {
            dataReturnAgent.setError(e);
            return false;
        }
    }

    private boolean isOptionsRequest(HttpCarbonMessage inboundMessage) {
        return inboundMessage.getHeader(HttpHeaderNames.ALLOW.toString()) != null;
    }

    private HttpResource validateHTTPMethod(List<HttpResource> resources, HttpCarbonMessage carbonMessage) {
        HttpResource httpResource = null;
        boolean isOptionsRequest = false;
        String httpMethod = carbonMessage.getHttpMethod();
        for (HttpResource resourceInfo : resources) {
            if (!DispatcherUtil.isMatchingMethodExist(resourceInfo, httpMethod)) continue;
            httpResource = resourceInfo;
            break;
        }
        if (httpResource == null) {
            httpResource = this.tryMatchingToDefaultVerb(resources);
        }
        if (httpResource == null) {
            isOptionsRequest = this.setAllowHeadersIfOPTIONS(httpMethod, carbonMessage);
        }
        if (httpResource != null) {
            return httpResource;
        }
        if (!isOptionsRequest) {
            carbonMessage.setHttpStatusCode(Integer.valueOf(405));
            throw new BallerinaException("Method not allowed");
        }
        return null;
    }

    private HttpResource tryMatchingToDefaultVerb(List<HttpResource> resources) {
        for (HttpResource resourceInfo : resources) {
            if (resourceInfo.getMethods() != null) continue;
            return resourceInfo;
        }
        return null;
    }

    private boolean setAllowHeadersIfOPTIONS(String httpMethod, HttpCarbonMessage cMsg) {
        if (httpMethod.equals("OPTIONS")) {
            cMsg.setHeader(HttpHeaderNames.ALLOW.toString(), this.getAllowHeaderValues(cMsg));
            return true;
        }
        return false;
    }

    private String getAllowHeaderValues(HttpCarbonMessage cMsg) {
        List<String> methods = new ArrayList<String>();
        ArrayList<HttpResource> resourceInfos = new ArrayList<HttpResource>();
        for (HttpResource resourceInfo : this.resource) {
            if (resourceInfo.getMethods() != null) {
                methods.addAll(resourceInfo.getMethods());
            }
            resourceInfos.add(resourceInfo);
        }
        cMsg.setProperty("PREFLIGHT_RESOURCES", resourceInfos);
        methods = DispatcherUtil.validateAllowMethods(methods);
        return DispatcherUtil.concatValues(methods, false);
    }

    private void validateConsumes(HttpResource resource, HttpCarbonMessage cMsg) {
        String contentMediaType = this.extractContentMediaType(cMsg.getHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
        List<String> consumesList = resource.getConsumes();
        if (consumesList == null) {
            return;
        }
        contentMediaType = contentMediaType != null ? contentMediaType : "value";
        for (String consumeType : consumesList) {
            if (!contentMediaType.equalsIgnoreCase(consumeType.trim())) continue;
            return;
        }
        cMsg.setHttpStatusCode(Integer.valueOf(415));
        throw new BallerinaException();
    }

    private String extractContentMediaType(String header) {
        if (header == null) {
            return null;
        }
        if (header.contains(";")) {
            header = header.substring(0, header.indexOf(59)).trim();
        }
        return header;
    }

    private void validateProduces(HttpResource resource, HttpCarbonMessage cMsg) {
        List<String> acceptMediaTypes = this.extractAcceptMediaTypes(cMsg.getHeader(HttpHeaderNames.ACCEPT.toString()));
        List<String> producesList = resource.getProduces();
        if (producesList == null || acceptMediaTypes == null) {
            return;
        }
        if (acceptMediaTypes.contains("*/*")) {
            return;
        }
        if (acceptMediaTypes.stream().anyMatch(mediaType -> mediaType.contains("/*"))) {
            List subTypeWildCardMediaTypes = acceptMediaTypes.stream().filter(mediaType -> mediaType.contains("/*")).map(mediaType -> mediaType.substring(0, mediaType.indexOf(47))).collect(Collectors.toList());
            for (String token : resource.getProducesSubTypes()) {
                if (!subTypeWildCardMediaTypes.contains(token)) continue;
                return;
            }
        }
        List noWildCardMediaTypes = acceptMediaTypes.stream().filter(mediaType -> !mediaType.contains("/*")).collect(Collectors.toList());
        for (String produceType : producesList) {
            if (!noWildCardMediaTypes.stream().anyMatch(produceType::equalsIgnoreCase)) continue;
            return;
        }
        cMsg.setHttpStatusCode(Integer.valueOf(406));
        throw new BallerinaException();
    }

    private List<String> extractAcceptMediaTypes(String header) {
        if (header == null) {
            return null;
        }
        List<String> acceptMediaTypes = new ArrayList<String>();
        if (header.contains(",")) {
            acceptMediaTypes = Arrays.stream(header.split(",")).map(mediaRange -> mediaRange.contains(";") ? mediaRange.substring(0, mediaRange.indexOf(59)) : mediaRange).map(String::trim).distinct().collect(Collectors.toList());
        } else if (header.contains(";")) {
            acceptMediaTypes.add(header.substring(0, header.indexOf(59)).trim());
        } else {
            acceptMediaTypes.add(header.trim());
        }
        return acceptMediaTypes;
    }
}

