/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.List;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpUtil;

public class SignatureParams {
    private HttpResource resource;
    private final List<BType> paramTypes;
    private BType entityBody;
    private List<BType> pathParamTypes;
    private int paramCount = 2;

    SignatureParams(HttpResource resource) {
        this.resource = resource;
        this.paramTypes = resource.getParamTypes();
    }

    void validate() {
        if (this.resource.getEntityBodyAttributeValue() == null || this.resource.getEntityBodyAttributeValue().isEmpty()) {
            this.validatePathParam(this.paramTypes.subList(2, this.paramTypes.size()));
        } else {
            int lastParamIndex = this.paramTypes.size() - 1;
            this.validatePathParam(this.paramTypes.subList(2, lastParamIndex));
            this.validateEntityBodyParam(this.paramTypes.get(lastParamIndex));
        }
    }

    private void validatePathParam(List<BType> paramDetails) {
        for (BType paramType : paramDetails) {
            int varTag = paramType.getTag();
            if (varTag != 5 && varTag != 1 && varTag != 6 && varTag != 3) {
                throw HttpUtil.createHttpError("incompatible resource signature parameter type", HttpErrorType.GENERIC_LISTENER_ERROR);
            }
            ++this.paramCount;
        }
        this.pathParamTypes = paramDetails;
    }

    private void validateEntityBodyParam(BType entityBodyParamType) {
        int type = entityBodyParamType.getTag();
        if (type == 12 || type == 7 || type == 8 || type == 5 || type == 20 && this.validArrayType(entityBodyParamType)) {
            this.entityBody = entityBodyParamType;
            ++this.paramCount;
        } else {
            throw HttpUtil.createHttpError("incompatible entity-body type : " + entityBodyParamType.getName(), HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    private boolean validArrayType(BType entityBodyParamType) {
        return ((BArrayType)entityBodyParamType).getElementType().getTag() == 2 || ((BArrayType)entityBodyParamType).getElementType().getTag() == 12;
    }

    BType getEntityBody() {
        return this.entityBody;
    }

    List<BType> getPathParamTypes() {
        return this.pathParamTypes;
    }

    int getParamCount() {
        return this.paramCount;
    }
}

