/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import java.util.Locale;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class Execute
extends AbstractHTTPAction {
    public static Object execute(ObjectValue httpClient, String verb, String path, ObjectValue requestObj) {
        String url = httpClient.getStringValue("url");
        Strand strand = Scheduler.getStrand();
        MapValue config = (MapValue)httpClient.get("config");
        HttpClientConnector clientConnector = (HttpClientConnector)httpClient.getNativeData("Client");
        HttpCarbonMessage outboundRequestMsg = Execute.createOutboundRequestMsg(strand, config, url, verb, path, requestObj);
        DataContext dataContext = new DataContext(strand, clientConnector, new NonBlockingCallback(strand), requestObj, outboundRequestMsg);
        Execute.executeNonBlockingAction(dataContext, false);
        return null;
    }

    protected static HttpCarbonMessage createOutboundRequestMsg(Strand strand, MapValue config, String serviceUri, String httpVerb, String path, ObjectValue requestObj) {
        HttpCarbonMessage outboundRequestMsg = HttpUtil.getCarbonMsg(requestObj, HttpUtil.createHttpCarbonMessage(true));
        HttpUtil.checkEntityAvailability(requestObj);
        HttpUtil.enrichOutboundMessage(outboundRequestMsg, requestObj);
        Execute.prepareOutboundRequest(strand, serviceUri, path, outboundRequestMsg, Execute.isNoEntityBodyRequest(requestObj));
        if (httpVerb == null || httpVerb.isEmpty()) {
            httpVerb = outboundRequestMsg.getHttpMethod();
        }
        outboundRequestMsg.setHttpMethod(httpVerb.trim().toUpperCase(Locale.getDefault()));
        Execute.handleAcceptEncodingHeader(outboundRequestMsg, Execute.getCompressionConfigFromEndpointConfig(config));
        return outboundRequestMsg;
    }
}

