/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.websocketconnector;

import io.netty.channel.ChannelFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.websocket.WebSocketConstants;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

public class Close {
    private static final Logger log = LoggerFactory.getLogger(Close.class);

    public static Object externClose(ObjectValue wsConnection, long statusCode, String reason, long timeoutInSecs) {
        Strand strand = Scheduler.getStrand();
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        WebSocketObservabilityUtil.observeResourceInvocation(strand, connectionInfo, "close");
        try {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ChannelFuture closeFuture = Close.initiateConnectionClosure(callback, (int)statusCode, reason, connectionInfo, countDownLatch);
            Close.waitForTimeout(callback, (int)timeoutInSecs, countDownLatch, connectionInfo);
            closeFuture.channel().close().addListener(future -> {
                WebSocketUtil.setListenerOpenField(connectionInfo);
                callback.setReturnValues(null);
                callback.notifySuccess();
            });
            WebSocketObservabilityUtil.observeSend("close", connectionInfo);
        }
        catch (Exception e) {
            log.error("Error occurred when closing the connection", (Throwable)e);
            WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "close", e.getMessage());
            callback.notifyFailure((BError)WebSocketUtil.createErrorByType(e));
        }
        return null;
    }

    private static ChannelFuture initiateConnectionClosure(NonBlockingCallback callback, int statusCode, String reason, WebSocketConnectionInfo connectionInfo, CountDownLatch latch) throws IllegalAccessException {
        WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
        ChannelFuture closeFuture = statusCode < 0 ? webSocketConnection.initiateConnectionClosure() : webSocketConnection.initiateConnectionClosure(statusCode, reason);
        return closeFuture.addListener(future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                callback.setReturnValues((Object)new WebSocketException(WebSocketConstants.ErrorCode.WsConnectionClosureError, cause.getMessage()));
                WebSocketObservabilityUtil.observeError(connectionInfo, "close", cause.getMessage());
            } else {
                callback.setReturnValues(null);
            }
            latch.countDown();
        });
    }

    private static void waitForTimeout(NonBlockingCallback callback, int timeoutInSecs, CountDownLatch latch, WebSocketConnectionInfo connectionInfo) {
        try {
            if (timeoutInSecs < 0) {
                latch.await();
            } else {
                boolean countDownReached = latch.await(timeoutInSecs, TimeUnit.SECONDS);
                if (!countDownReached) {
                    String errMsg = String.format("Could not receive a WebSocket close frame from remote endpoint within %d seconds", timeoutInSecs);
                    callback.setReturnValues((Object)new WebSocketException(WebSocketConstants.ErrorCode.WsConnectionClosureError, errMsg));
                    WebSocketObservabilityUtil.observeError(connectionInfo, "close", errMsg);
                }
            }
        }
        catch (InterruptedException err) {
            String errMsg = "Connection interrupted while closing the connection";
            callback.setReturnValues((Object)new WebSocketException(WebSocketConstants.ErrorCode.WsConnectionClosureError, errMsg));
            WebSocketObservabilityUtil.observeError(connectionInfo, "close", errMsg);
            Thread.currentThread().interrupt();
        }
    }

    private Close() {
    }
}

