/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.caching;

import java.util.Map;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.caching.CacheControlDirective;
import org.ballerinalang.net.http.caching.CacheControlParser;

public class RequestCacheControlObj {
    private ObjectValue requestCacheControl;

    public RequestCacheControlObj(ObjectValue requestCacheControl) {
        this.requestCacheControl = requestCacheControl;
        requestCacheControl.set("noTransform", (Object)true);
        requestCacheControl.set("maxAge", (Object)-1);
        requestCacheControl.set("maxStale", (Object)-1);
        requestCacheControl.set("minFresh", (Object)-1);
    }

    public ObjectValue getObj() {
        return this.requestCacheControl;
    }

    public RequestCacheControlObj setNoCache(boolean noCache) {
        this.requestCacheControl.set("noCache", (Object)noCache);
        return this;
    }

    public RequestCacheControlObj setNoStore(boolean noStore) {
        this.requestCacheControl.set("noStore", (Object)noStore);
        return this;
    }

    public RequestCacheControlObj setNoTransform(boolean noTransform) {
        this.requestCacheControl.set("noTransform", (Object)noTransform);
        return this;
    }

    public RequestCacheControlObj setOnlyIfCached(boolean onlyIfCached) {
        this.requestCacheControl.set("onlyIfCached", (Object)onlyIfCached);
        return this;
    }

    public RequestCacheControlObj setMaxAge(long maxAge) {
        this.requestCacheControl.set("maxAge", (Object)maxAge);
        return this;
    }

    public RequestCacheControlObj setMaxStale(long maxStale) {
        this.requestCacheControl.set("maxStale", (Object)maxStale);
        return this;
    }

    public RequestCacheControlObj setMinFresh(long minFresh) {
        this.requestCacheControl.set("minFresh", (Object)minFresh);
        return this;
    }

    public void populateStruct(String cacheControlHeaderVal) {
        Map<CacheControlDirective, String> controlDirectives = CacheControlParser.parse(cacheControlHeaderVal);
        controlDirectives.forEach((directive, value) -> {
            switch (directive) {
                case NO_CACHE: {
                    this.requestCacheControl.set("noCache", (Object)true);
                    break;
                }
                case NO_STORE: {
                    this.requestCacheControl.set("noStore", (Object)true);
                    break;
                }
                case NO_TRANSFORM: {
                    this.requestCacheControl.set("noTransform", (Object)true);
                    break;
                }
                case ONLY_IF_CACHED: {
                    this.requestCacheControl.set("onlyIfCached", (Object)true);
                    break;
                }
                case MAX_AGE: {
                    try {
                        this.requestCacheControl.set("maxAge", (Object)Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        this.requestCacheControl.set("maxAge", (Object)0);
                    }
                    break;
                }
                case MAX_STALE: {
                    try {
                        this.requestCacheControl.set("maxStale", (Object)Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        this.requestCacheControl.set("maxStale", (Object)0);
                    }
                    break;
                }
                case MIN_FRESH: {
                    try {
                        this.requestCacheControl.set("minFresh", (Object)Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        this.requestCacheControl.set("minFresh", (Object)0);
                    }
                    break;
                }
            }
        });
    }
}

