/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.compiler;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.net.http.compiler.ResourceSignatureValidator;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="http", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="http", name="Caller"), @SupportedResourceParamTypes.Type(packageName="http", name="Request")})
public class HttpServiceCompilerPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        List resources = serviceNode.getResources();
        if (resources.size() > 0 && ((BLangFunction)resources.get(0)).getParameters().size() > 0 && "ballerina/http:WebSocketCaller".equals(((BLangSimpleVariable)((BLangFunction)resources.get((int)0)).getParameters().get((int)0)).type.toString())) {
            return;
        }
        int serviceConfigCount = 0;
        for (AnnotationAttachmentNode annotation : annotations) {
            if (!annotation.getAnnotationName().getValue().equals("ServiceConfig")) continue;
            this.handleServiceConfigAnnotation(serviceNode, (BLangAnnotationAttachment)annotation);
            ++serviceConfigCount;
        }
        if (serviceConfigCount > 1) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("multiple service configuration annotations found in service : " + serviceNode.getName().getValue()));
        }
        resources.forEach(res -> ResourceSignatureValidator.validate((FunctionNode)res, this.dlog, res.pos));
    }

    private void handleServiceConfigAnnotation(ServiceNode serviceNode, BLangAnnotationAttachment annotation) {
        if (annotation.getExpression() == null) {
            return;
        }
        ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> annotationValues = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
        for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)annotation.getExpression()).fields) {
            annotationValues.add((BLangRecordLiteral.BLangRecordKeyValueField)field);
        }
        int compressionConfigCount = 0;
        block1: for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : annotationValues) {
            if (!this.checkMatchingConfigKey(keyValue, "compression")) continue;
            if (compressionConfigCount++ == 1) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"Invalid multiple configurations for compression");
                return;
            }
            for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)keyValue.valueExpr).getFields()) {
                BLangRecordLiteral.BLangRecordKeyValueField compressionConfig = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                if (!this.checkMatchingConfigKey(compressionConfig, "contentTypes")) continue;
                BLangListConstructorExpr valueArray = (BLangListConstructorExpr)compressionConfig.valueExpr;
                if (valueArray.getExpressions().isEmpty()) continue block1;
                for (ExpressionNode expressionNode : valueArray.getExpressions()) {
                    String contentType = expressionNode.toString();
                    if (MimeUtil.isValidateContentType((String)contentType)) continue;
                    this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("Invalid Content-Type value for compression: '" + contentType + "'"));
                    return;
                }
            }
        }
    }

    private boolean checkMatchingConfigKey(BLangRecordLiteral.BLangRecordKeyValueField keyValue, String key) {
        return ((BLangSimpleVarRef)keyValue.key.expr).variableName.getValue().equals(key);
    }
}

