/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.websocket.WebSocketConstants;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;

public class CancelWebSocketUpgrade {
    private static final Logger log = LoggerFactory.getLogger(CancelWebSocketUpgrade.class);

    public static Object cancelWebSocketUpgrade(ObjectValue connectionObj, long statusCode, String reason) {
        NonBlockingCallback callback = new NonBlockingCallback(Scheduler.getStrand());
        try {
            WebSocketHandshaker webSocketHandshaker = (WebSocketHandshaker)connectionObj.getNativeData("WEBSOCKET_MESSAGE");
            if (webSocketHandshaker == null) {
                callback.notifyFailure((BError)new WebSocketException(WebSocketConstants.ErrorCode.WsInvalidHandshakeError, "Not a WebSocket upgrade request. Cannot cancel the request"));
                return null;
            }
            ChannelFuture future = webSocketHandshaker.cancelHandshake((int)statusCode, reason);
            future.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                Throwable cause = future.cause();
                if (channelFuture.channel().isOpen()) {
                    channelFuture.channel().close();
                }
                if (!future.isSuccess() && cause != null) {
                    callback.notifyFailure((BError)WebSocketUtil.createErrorByType(cause));
                } else {
                    callback.setReturnValues(null);
                    callback.notifySuccess();
                }
            }));
        }
        catch (Exception e) {
            log.error("Error when cancelling WebsSocket upgrade request", (Throwable)e);
            callback.notifyFailure((BError)WebSocketUtil.createErrorByType(e));
        }
        return null;
    }

    private CancelWebSocketUpgrade() {
    }
}

