/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.connection;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Optional;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.State;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.caching.ResponseCacheControlObj;
import org.ballerinalang.net.http.nativeimpl.connection.ConnectionAction;
import org.ballerinalang.net.http.nativeimpl.pipelining.PipelinedResponse;
import org.ballerinalang.net.http.nativeimpl.pipelining.PipeliningHandler;
import org.ballerinalang.net.http.util.CacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class Respond
extends ConnectionAction {
    private static final Logger log = LoggerFactory.getLogger(Respond.class);

    public static Object nativeRespond(ObjectValue connectionObj, ObjectValue outboundResponseObj) {
        HttpCarbonMessage inboundRequestMsg = HttpUtil.getCarbonMsg(connectionObj, null);
        Strand strand = Scheduler.getStrand();
        DataContext dataContext = new DataContext(strand, new NonBlockingCallback(strand), inboundRequestMsg);
        if (Respond.isDirtyResponse(outboundResponseObj)) {
            String errorMessage = "Couldn't complete the respond operation as the response has been already used.";
            HttpUtil.sendOutboundResponse(inboundRequestMsg, HttpUtil.createErrorMessage(errorMessage, 500));
            Respond.unBlockStrand(strand);
            if (log.isDebugEnabled()) {
                log.debug("Couldn't complete the respond operation for the sequence id of the request: {} as the response has been already used.", (Object)inboundRequestMsg.getSequenceId());
            }
            return HttpUtil.createHttpError(errorMessage, HttpErrorType.GENERIC_LISTENER_ERROR);
        }
        outboundResponseObj.addNativeData("dirtyResponse", (Object)true);
        HttpCarbonMessage outboundResponseMsg = HttpUtil.getCarbonMsg(outboundResponseObj, HttpUtil.createHttpCarbonMessage(false));
        outboundResponseMsg.setPipeliningEnabled(inboundRequestMsg.isPipeliningEnabled());
        outboundResponseMsg.setSequenceId(inboundRequestMsg.getSequenceId());
        Respond.setCacheControlHeader(outboundResponseObj, outboundResponseMsg);
        HttpUtil.prepareOutboundResponse(connectionObj, inboundRequestMsg, outboundResponseMsg, outboundResponseObj);
        HttpUtil.checkFunctionValidity(connectionObj, inboundRequestMsg, outboundResponseMsg);
        if (CacheUtils.isValidCachedResponse(outboundResponseMsg, inboundRequestMsg)) {
            outboundResponseMsg.setHttpStatusCode(Integer.valueOf(HttpResponseStatus.NOT_MODIFIED.code()));
            outboundResponseMsg.setProperty("HTTP_REASON_PHRASE", (Object)HttpResponseStatus.NOT_MODIFIED.reasonPhrase());
            outboundResponseMsg.removeHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
            outboundResponseMsg.removeHeader(HttpHeaderNames.CONTENT_TYPE.toString());
            outboundResponseMsg.waitAndReleaseAllEntities();
            outboundResponseMsg.completeMessage();
        }
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        observerContext.ifPresent(ctx -> ctx.addTag("http.status_code", String.valueOf(outboundResponseObj.get("statusCode"))));
        try {
            if (PipeliningHandler.pipeliningRequired(inboundRequestMsg)) {
                if (log.isDebugEnabled()) {
                    log.debug("Pipelining is required. Sequence id of the request: {}", (Object)inboundRequestMsg.getSequenceId());
                }
                PipelinedResponse pipelinedResponse = new PipelinedResponse(inboundRequestMsg, outboundResponseMsg, dataContext, outboundResponseObj);
                PipeliningHandler.setPipeliningListener(outboundResponseMsg);
                PipeliningHandler.executePipeliningLogic(inboundRequestMsg.getSourceContext(), pipelinedResponse);
            } else {
                Respond.sendOutboundResponseRobust(dataContext, inboundRequestMsg, outboundResponseObj, outboundResponseMsg);
            }
        }
        catch (ErrorValue e) {
            Respond.unBlockStrand(strand);
            log.debug(e.getPrintableStackTrace(), (Throwable)e);
            return e;
        }
        catch (Throwable e) {
            Respond.unBlockStrand(strand);
            String errorMessage = "Couldn't complete outbound response";
            log.debug(errorMessage, e);
            return HttpUtil.createHttpError(errorMessage, HttpErrorType.GENERIC_LISTENER_ERROR);
        }
        return null;
    }

    private static void unBlockStrand(Strand strand) {
        strand.setState(State.RUNNABLE);
        strand.blockedOnExtern = false;
    }

    private static void setCacheControlHeader(ObjectValue outboundRespObj, HttpCarbonMessage outboundResponse) {
        ObjectValue cacheControl = (ObjectValue)outboundRespObj.get("cacheControl");
        if (cacheControl != null && outboundResponse.getHeader(HttpHeaderNames.CACHE_CONTROL.toString()) == null) {
            ResponseCacheControlObj respCC = new ResponseCacheControlObj(cacheControl);
            outboundResponse.setHeader(HttpHeaderNames.CACHE_CONTROL.toString(), respCC.buildCacheControlDirectives());
        }
    }

    private static boolean isDirtyResponse(ObjectValue outboundResponseObj) {
        return outboundResponseObj.get("cacheControl") == null && outboundResponseObj.getNativeData("dirtyResponse") != null;
    }
}

