/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.values.ObjectValue;

public class WebSocketService {
    protected final ObjectValue service;
    protected Scheduler scheduler;
    private final Map<String, AttachedFunction> resourcesMap = new ConcurrentHashMap<String, AttachedFunction>();

    public WebSocketService(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.service = null;
    }

    public WebSocketService(ObjectValue service, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.service = service;
        this.populateResourcesMap(service);
    }

    private void populateResourcesMap(ObjectValue service) {
        for (AttachedFunction resource : service.getType().getAttachedFunctions()) {
            this.resourcesMap.put(resource.getName(), resource);
        }
    }

    public AttachedFunction getResourceByName(String resourceName) {
        return this.resourcesMap.get(resourceName);
    }

    public ObjectValue getBalService() {
        return this.service;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

