/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client.listener;

import java.io.IOException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketResourceDispatcher;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.FailoverContext;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedHandshakeListener;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;

public class FailoverHandshakeListener
implements ExtendedHandshakeListener {
    private final WebSocketService wsService;
    private ExtendedHandshakeListener handshakeListener;
    private static final Logger logger = LoggerFactory.getLogger(FailoverHandshakeListener.class);
    public static final String CONNECTED_TO = "Connected to ";
    public static final String LOG_MESSAGE = "{} {}";

    public FailoverHandshakeListener(ExtendedHandshakeListener handshakeListener, WebSocketService wsService) {
        this.handshakeListener = handshakeListener;
        this.wsService = wsService;
    }

    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse response) {
        this.handshakeListener.onSuccess(webSocketConnection, response);
        FailoverContext failoverContext = (FailoverContext)this.getWebSocketClient().getNativeData("failoverContext");
        int currentIndex = failoverContext.getCurrentIndex();
        if (logger.isDebugEnabled()) {
            logger.debug(LOG_MESSAGE, (Object)CONNECTED_TO, (Object)failoverContext.getTargetUrls().get(failoverContext.getCurrentIndex()));
        }
        failoverContext.setInitialIndex(currentIndex);
        failoverContext.setFirstConnectionEstablished();
    }

    public void onError(Throwable throwable, HttpCarbonResponse response) {
        this.handshakeListener.onError(throwable, response);
        ObjectValue webSocketClient = this.getWebSocketClient();
        if (!(throwable instanceof IOException) || !WebSocketUtil.failover(webSocketClient, this.wsService)) {
            WebSocketUtil.countDownForHandshake(webSocketClient);
            WebSocketResourceDispatcher.dispatchOnError(this.getWebSocketConnectionInfo(), throwable);
        }
    }

    @Override
    public ObjectValue getWebSocketClient() {
        return this.handshakeListener.getWebSocketClient();
    }

    @Override
    public WebSocketConnectionInfo getWebSocketConnectionInfo() {
        return this.handshakeListener.getWebSocketConnectionInfo();
    }
}

