/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client.listener;

import java.io.IOException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketResourceDispatcher;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.RetryContext;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedHandshakeListener;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;

public class RetryHandshakeListener
implements ExtendedHandshakeListener {
    private RetryContext retryContext;
    private final WebSocketService wsService;
    private ExtendedHandshakeListener handshakeListener;
    private static final Logger logger = LoggerFactory.getLogger(RetryHandshakeListener.class);
    public static final String CONNECTED_TO = "Connected to ";
    public static final String LOG_MESSAGE = "{} {}";

    public RetryHandshakeListener(ExtendedHandshakeListener handshakeListener, RetryContext retryContext, WebSocketService wsService) {
        this.handshakeListener = handshakeListener;
        this.retryContext = retryContext;
        this.wsService = wsService;
    }

    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse response) {
        this.handshakeListener.onSuccess(webSocketConnection, response);
        if (logger.isDebugEnabled()) {
            logger.debug(LOG_MESSAGE, (Object)CONNECTED_TO, (Object)this.getWebSocketClient().getStringValue("url"));
        }
        this.retryContext.setFirstConnectionEstablished();
        this.retryContext.setReconnectAttempts(0);
    }

    public void onError(Throwable throwable, HttpCarbonResponse response) {
        this.handshakeListener.onError(throwable, response);
        if (throwable instanceof IOException && WebSocketUtil.reconnect(this.getWebSocketClient(), this.wsService)) {
            return;
        }
        WebSocketResourceDispatcher.dispatchOnError(this.getWebSocketConnectionInfo(), throwable);
    }

    @Override
    public ObjectValue getWebSocketClient() {
        return this.handshakeListener.getWebSocketClient();
    }

    @Override
    public WebSocketConnectionInfo getWebSocketConnectionInfo() {
        return this.handshakeListener.getWebSocketConnectionInfo();
    }
}

