/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri;

import java.io.UnsupportedEncodingException;
import org.ballerinalang.net.http.HttpResourceArguments;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.DataElement;
import org.ballerinalang.net.uri.parser.DataElementFactory;
import org.ballerinalang.net.uri.parser.DataReturnAgent;
import org.ballerinalang.net.uri.parser.Node;
import org.ballerinalang.net.uri.parser.URITemplateParser;

public class URITemplate<DataType, InboundMsgType> {
    private Node<DataType, InboundMsgType> syntaxTree;

    public URITemplate(Node<DataType, InboundMsgType> syntaxTree) {
        this.syntaxTree = syntaxTree;
    }

    public DataType matches(String uri, HttpResourceArguments variables, InboundMsgType inboundMsg) {
        DataReturnAgent dataReturnAgent = new DataReturnAgent();
        boolean isFound = this.syntaxTree.matchAll(uri, variables, 0, inboundMsg, dataReturnAgent);
        if (isFound) {
            return dataReturnAgent.getData();
        }
        if (dataReturnAgent.getError() != null) {
            throw dataReturnAgent.getError();
        }
        return null;
    }

    public void parse(String uriTemplate, DataType resource, DataElementFactory<? extends DataElement<DataType, InboundMsgType>> elementCreator) throws URITemplateException, UnsupportedEncodingException {
        uriTemplate = this.removeTheFirstAndLastBackSlash(uriTemplate);
        URITemplateParser<DataType, InboundMsgType> parser = new URITemplateParser<DataType, InboundMsgType>(this.syntaxTree, elementCreator);
        parser.parse(uriTemplate, resource);
    }

    private String removeTheFirstAndLastBackSlash(String template) throws URITemplateException {
        String uri = template;
        if ("/".equals(uri)) {
            return uri;
        }
        if (uri.startsWith("*")) {
            throw new URITemplateException("Invalid path literal");
        }
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }
}

