/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri.parser;

import org.ballerinalang.net.http.HttpResourceArguments;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.DataElement;
import org.ballerinalang.net.uri.parser.Node;
import org.ballerinalang.net.uri.parser.SimpleStringExpression;

public class DotSuffixExpression<DataType, InboundMsgType>
extends SimpleStringExpression<DataType, InboundMsgType> {
    public DotSuffixExpression(DataElement<DataType, InboundMsgType> dataElement, String token) throws URITemplateException {
        super(dataElement, token);
    }

    @Override
    int match(String uriFragment, HttpResourceArguments variables) {
        String pathSegment = uriFragment;
        if (uriFragment.contains("/")) {
            pathSegment = uriFragment.substring(0, uriFragment.indexOf("/"));
        }
        String[] subSegments = pathSegment.split("\\.");
        int endCharacterCount = subSegments.length - 1;
        int dotSegmentCounter = 0;
        int length = uriFragment.length();
        for (int i = 0; i < length; ++i) {
            char ch = uriFragment.charAt(i);
            if (this.isEndCharacter(Character.valueOf(ch))) {
                if (++dotSegmentCounter != endCharacterCount) continue;
                if (!this.setVariables(uriFragment.substring(0, i), variables)) {
                    return -1;
                }
                return i;
            }
            if (i != length - 1) continue;
            if (!this.setVariables(uriFragment, variables)) {
                return -1;
            }
            return length;
        }
        return 0;
    }

    @Override
    protected boolean isEndCharacter(Character endCharacter) {
        for (Node childNode : this.childNodesList) {
            if (endCharacter.charValue() != childNode.getFirstCharacter() || endCharacter.charValue() != '.') continue;
            return true;
        }
        return false;
    }
}

