/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.jvm.launch.LaunchUtils;
import org.ballerinalang.packerina.TaskExecutor;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.packerina.task.CleanTargetDirTask;
import org.ballerinalang.packerina.task.CompileTask;
import org.ballerinalang.packerina.task.CopyExecutableTask;
import org.ballerinalang.packerina.task.CopyModuleJarTask;
import org.ballerinalang.packerina.task.CopyNativeLibTask;
import org.ballerinalang.packerina.task.CopyResourcesTask;
import org.ballerinalang.packerina.task.CreateBaloTask;
import org.ballerinalang.packerina.task.CreateBirTask;
import org.ballerinalang.packerina.task.CreateExecutableTask;
import org.ballerinalang.packerina.task.CreateJarTask;
import org.ballerinalang.packerina.task.CreateLockFileTask;
import org.ballerinalang.packerina.task.CreateTargetDirTask;
import org.ballerinalang.packerina.task.PrintExecutablePathTask;
import org.ballerinalang.packerina.task.ResolveMavenDependenciesTask;
import org.ballerinalang.packerina.task.RunCompilerPluginTask;
import org.ballerinalang.packerina.task.RunTestsTask;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="build", description={"Ballerina build - Build Ballerina module(s) and generate executable output."})
public class BuildCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path sourceRootPath;
    private boolean exitWhenFinish;
    private boolean skipCopyLibsFromDist;
    @CommandLine.Option(names={"--sourceroot"}, description={"Path to the directory containing the source files and modules"})
    private String sourceRoot;
    @CommandLine.Option(names={"--compile", "-c"}, description={"Compile the source without generating executable(s)."})
    private boolean compile;
    @CommandLine.Option(names={"--all", "-a"}, description={"Build or compile all the modules of the project."})
    private boolean buildAll;
    @CommandLine.Option(names={"--output", "-o"}, description={"Write the output to the given file. The provided output file name may or may not contain the '.jar' extension."})
    private String output;
    @CommandLine.Option(names={"--offline"}, description={"Build/Compile offline without downloading dependencies."})
    private boolean offline;
    @CommandLine.Option(names={"--skip-lock"}, description={"Skip using the lock file to resolve dependencies."})
    private boolean skipLock;
    @CommandLine.Option(names={"--skip-tests"}, description={"Skip test compilation and execution."})
    private boolean skipTests;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--native"}, hidden=true, description={"Compile a Ballerina program to a native binary."})
    private boolean nativeBinary;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--dump-llvm-ir"}, hidden=true)
    private boolean dumpLLVMIR;
    @CommandLine.Option(names={"--no-optimize-llvm"}, hidden=true)
    private boolean noOptimizeLlvm;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--debug"}, description={"run tests in remote debugging mode"})
    private String debugPort;
    private static final String buildCmd = "ballerina build [-o <output>] [--sourceroot] [--offline] [--skip-tests]\n                    [--skip-lock] {<ballerina-file | module-name> | -a | --all} [--] [(--key=value)...]";
    @CommandLine.Option(names={"--test-report"}, description={"Enable test report generation"})
    private boolean testReport;
    @CommandLine.Option(names={"--code-coverage"}, description={"Enable code coverage"})
    private boolean coverage;
    @CommandLine.Option(names={"--home-cache"}, description={"Custom home cache"})
    private String homeCache;
    @CommandLine.Option(names={"--includes"}, hidden=true, description={"hidden option for code coverage to include all classes"})
    private String includes;

    public BuildCommand() {
        this.sourceRootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
        this.skipCopyLibsFromDist = false;
    }

    public BuildCommand(Path userDir, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist) {
        this.sourceRootPath = userDir;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
    }

    public BuildCommand(Path userDir, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist, Path executableOutputDir) {
        this.sourceRootPath = userDir;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
        this.output = executableOutputDir.toString();
    }

    public void execute() {
        Path targetPath;
        String[] userArgs;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"build");
            this.errStream.println(commandUsageInfo);
            return;
        }
        String[] args = this.argList == null ? new String[]{} : (this.buildAll ? this.argList.toArray(new String[0]) : this.argList.subList(1, this.argList.size()).toArray(new String[0]));
        if (!this.skipTests && this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        if (!this.coverage && this.includes != null) {
            this.outStream.println("warning: ignoring --includes flag since code coverage is not enabled");
        }
        if ((userArgs = LaunchUtils.getUserArgs((String[])args, new HashMap())).length > 0) {
            CommandUtil.printError(this.errStream, "too many arguments.", buildCmd, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!(this.buildAll || this.argList != null && this.argList.size() != 0)) {
            CommandUtil.printError(this.errStream, "'build' command requires a module name or a Ballerina file to build/compile. Use '-a' or '--all' to build/compile all the modules of the project.", "ballerina build {<ballerina-file> | <module-name> | -a | --all}", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.sourceRootPath = null != this.sourceRoot ? Paths.get(this.sourceRoot, new String[0]).toAbsolutePath() : this.sourceRootPath;
        Path sourcePath = null;
        if (this.buildAll) {
            if (null != this.output) {
                CommandUtil.printError(this.errStream, "'-o' and '--output' are only supported when building a single Ballerina file.", "ballerina build -o <output-file> <ballerina-file> ", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (!ProjectDirs.isProject((Path)this.sourceRootPath)) {
                Path findRoot = ProjectDirs.findProjectRoot((Path)this.sourceRootPath);
                if (null == findRoot) {
                    CommandUtil.printError(this.errStream, "you are trying to build/compile a Ballerina project that does not have a Ballerina.toml file.", null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                this.sourceRootPath = findRoot;
            }
            targetPath = this.sourceRootPath.resolve("target");
        } else if (this.argList.get(0).endsWith(".bal")) {
            if (this.coverage) {
                this.coverage = false;
                this.outStream.println("Code coverage is not yet supported with single bal files. Ignoring the flag and continuing the test run...");
            }
            if (this.compile) {
                CommandUtil.printError(this.errStream, "'-c' or '--compile' can only be used with modules.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            sourcePath = Paths.get(this.argList.get(0), new String[0]).isAbsolute() ? Paths.get(this.argList.get(0), new String[0]) : this.sourceRootPath.resolve(this.argList.get(0));
            this.sourceRootPath = sourcePath.getParent();
            if (Files.notExists(sourcePath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' Ballerina file does not exist.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (!Files.isRegularFile(sourcePath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' is not a Ballerina file. Check if it is a symlink or a shortcut.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            try {
                targetPath = Files.createTempDirectory("ballerina-build-" + System.nanoTime(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"Error occurred when creating the executable.");
            }
        } else if (Files.exists(this.sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0]) && Files.isDirectory(this.sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0])) {
            if (null != this.output) {
                CommandUtil.printError(this.errStream, "'-o' and '--output' are only supported for building a single Ballerina file.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (!RepoUtils.isBallerinaProject((Path)this.sourceRootPath)) {
                CommandUtil.printError(this.errStream, "you are trying to build/compile a module that is not inside a project.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (Paths.get(this.argList.get(0), new String[0]).isAbsolute()) {
                CommandUtil.printError(this.errStream, "you are trying to build/compile a module giving the absolute path. You only need to give the name of the module.", "ballerina build [-c] <module-name>", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            String moduleName = this.argList.get(0);
            if (moduleName.endsWith("/")) {
                moduleName = moduleName.substring(0, moduleName.length() - 1);
            }
            sourcePath = Paths.get(moduleName, new String[0]);
            if (Files.notExists(this.sourceRootPath.resolve("src").resolve(sourcePath), new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "'" + sourcePath + "' module does not exist.", "ballerina build [-c] <module-name>", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            targetPath = this.sourceRootPath.resolve("target");
        } else {
            CommandUtil.printError(this.errStream, "invalid Ballerina source path. It should either be a name of a module in a Ballerina project or a file with a '.bal' extension. Use -a or --all to build or compile all modules.", "ballerina build {<ballerina-file> | <module-name> | -a | --all}", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.homeCache != null) {
            System.setProperty("HOME_CACHE_DIR", this.homeCache);
        }
        this.sourceRootPath = this.sourceRootPath.normalize();
        sourcePath = sourcePath == null ? null : sourcePath.normalize();
        targetPath = targetPath.normalize();
        CompilerContext compilerContext = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)compilerContext);
        options.put(CompilerOptionName.PROJECT_DIR, this.sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(this.offline));
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.BIR_GEN.toString());
        options.put(CompilerOptionName.LOCK_ENABLED, Boolean.toString(!this.skipLock));
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(this.skipTests));
        options.put(CompilerOptionName.TEST_ENABLED, Boolean.toString(!this.skipTests));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(this.experimentalFlag));
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "true");
        BuildContext buildContext = new BuildContext(this.sourceRootPath, targetPath, sourcePath, compilerContext);
        buildContext.setOut(this.outStream);
        buildContext.setErr(this.errStream);
        boolean isSingleFileBuild = buildContext.getSourceType().equals((Object)SourceType.SINGLE_BAL_FILE);
        Path outputPath = null == this.output ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(this.output, new String[0]);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(), isSingleFileBuild).addTask(new CreateTargetDirTask()).addTask(new CompileTask()).addTask(new CreateLockFileTask(), this.skipLock || isSingleFileBuild).addTask(new ResolveMavenDependenciesTask(), this.compile).addTask(new CreateBaloTask(), isSingleFileBuild).addTask(new CreateBirTask()).addTask(new CopyNativeLibTask(this.skipCopyLibsFromDist)).addTask(new CreateJarTask(this.dumpBIR, this.skipCopyLibsFromDist)).addTask(new CopyResourcesTask(), isSingleFileBuild).addTask(new CopyModuleJarTask(this.skipCopyLibsFromDist, this.skipTests)).addTask(new RunTestsTask(this.testReport, this.coverage, args, this.includes), this.skipTests || isSingleFileBuild).addTask(new CreateExecutableTask(), this.compile).addTask(new CopyExecutableTask(outputPath), !isSingleFileBuild).addTask(new PrintExecutablePathTask(), this.compile).addTask(new RunCompilerPluginTask(), this.compile).addTask(new CleanTargetDirTask(), !isSingleFileBuild).build();
        taskExecutor.executeTasks(buildContext);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    public String getName() {
        return "build";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Build a Ballerina module(s)/file and produce an executable JAR file(s). \n");
        out.append("\n");
        out.append("Build a Ballerina project or a specific module in a project. The \n");
        out.append("executable \".jar\" files will be created in the <PROJECT-ROOT>/target/bin directory. \n");
        out.append("\n");
        out.append("Build a single Ballerina file. This creates an executable .jar file in the \n");
        out.append("current directory. The name of the executable file will be \n");
        out.append("<ballerina-file-name>.jar. \n");
        out.append("\n");
        out.append("If the output file is specified with the -o flag, the output \n");
        out.append("will be written to the given output file name. The -o flag will only \n");
        out.append("work for single files. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina build [-o <output-file>] [--offline] [--skip-tests] [--skip-lock] {<ballerina-file | module-name> | -a | --all} [--] [(--key=value)...]\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

