/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.packerina.ListUtils;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"list dependencies of modules"})
public class ListCommand
implements BLauncherCmd {
    private static final String USER_DIR = "user.dir";
    private static PrintStream outStream = System.err;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"list");
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.argList != null && this.argList.size() > 1) {
            throw LauncherUtils.createUsageExceptionWithHelp((String)"too many arguments");
        }
        Path sourceRootPath = Paths.get(System.getProperty(USER_DIR), new String[0]);
        if (this.argList == null || this.argList.size() == 0) {
            ListUtils.list(sourceRootPath);
        } else if (Files.exists(sourceRootPath.resolve(".ballerina"), new LinkOption[0])) {
            String pkgName = this.argList.get(0);
            ListUtils.list(sourceRootPath, pkgName);
        } else {
            throw LauncherUtils.createLauncherException((String)"Current directory is not a project");
        }
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "list";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("lists dependencies of modules \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina list <module-name> \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

