/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.IOException;
import java.nio.file.Path;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleModuleContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.packerina.utils.FileUtils;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.SourceDirectoryManager;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class CleanTargetDirTask
implements Task {
    @Override
    public void execute(BuildContext buildContext) {
        Path targetDir = (Path)buildContext.get(BuildContextField.TARGET_DIR);
        try {
            if (buildContext.getSourceType() == SourceType.SINGLE_MODULE) {
                SourceDirectoryManager sourceDirectoryManager = SourceDirectoryManager.getInstance((CompilerContext)((CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT)));
                SingleModuleContext moduleContext = (SingleModuleContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
                PackageID packageID = sourceDirectoryManager.getPackageID(moduleContext.getModuleName());
                this.deleteResource(buildContext.getExecutablePathFromTarget(packageID));
                this.deleteResource(buildContext.getBaloFromTarget(packageID));
                this.deleteResource(buildContext.getBirPathFromTargetCache(packageID));
                this.deleteResource(buildContext.getTestBirPathFromTargetCache(packageID));
                this.deleteResource(buildContext.getJarPathFromTargetCache(packageID));
                this.deleteResource(buildContext.getTestJarPathFromTargetCache(packageID));
            } else {
                this.deleteResource(targetDir);
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("Unable to clean target : " + targetDir.toString() + "\n"), (Throwable)e);
        }
    }

    private void deleteResource(Path path) throws IOException {
        if (path != null && path.toFile().exists()) {
            FileUtils.deleteDirectory(path);
        }
    }
}

