/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import com.moandjiezana.toml.Toml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.model.ExecutableJar;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.Library;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;

public class CopyNativeLibTask
implements Task {
    private List<String> supportedPlatforms = Arrays.stream(ProgramFileConstants.SUPPORTED_PLATFORMS).collect(Collectors.toList());
    private boolean skipCopyLibsFromDist;
    private Manifest manifest;
    private boolean skipTests;
    private PackageCache packageCache;

    public CopyNativeLibTask(boolean skipCopyLibsFromDist) {
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
        this.supportedPlatforms.add("any");
    }

    public CopyNativeLibTask() {
        this(false);
    }

    @Override
    public void execute(BuildContext buildContext) {
        CompilerContext context = (CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT);
        this.packageCache = PackageCache.getInstance((CompilerContext)context);
        this.skipTests = buildContext.skipTests();
        Path sourceRootPath = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        String balHomePath = buildContext.get(BuildContextField.HOME_REPO).toString();
        this.manifest = ManifestProcessor.getInstance((CompilerContext)((CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT))).getManifest();
        this.copyImportedJarsForModules(buildContext, buildContext.getModules(), sourceRootPath, balHomePath);
    }

    private void copyImportedJarsForModules(BuildContext buildContext, List<BLangPackage> moduleBirMap, Path sourceRootPath, String balHomePath) {
        HashSet<PackageID> alreadyImportedSet = new HashSet<PackageID>();
        for (BLangPackage pkg : moduleBirMap) {
            PackageID packageID = pkg.packageID;
            BLangPackage bLangPackage = this.packageCache.get(packageID);
            if (bLangPackage == null || !buildContext.moduleDependencyPathMap.containsKey(packageID)) continue;
            this.copyImportedLibs(bLangPackage.symbol.imports, buildContext.moduleDependencyPathMap.get((Object)packageID).moduleLibs, buildContext, sourceRootPath, balHomePath, alreadyImportedSet);
            if (this.skipTests || !bLangPackage.hasTestablePackage()) continue;
            for (BLangPackage testPkg : bLangPackage.getTestablePkgs()) {
                if (!buildContext.moduleDependencyPathMap.containsKey(testPkg.packageID)) continue;
                this.copyImportedLibs(testPkg.symbol.imports, buildContext.moduleDependencyPathMap.get((Object)testPkg.packageID).testLibs, buildContext, sourceRootPath, balHomePath, alreadyImportedSet);
            }
        }
    }

    private void copyImportedLibs(List<BPackageSymbol> imports, Set<Path> moduleDependencySet, BuildContext buildContext, Path sourceRootPath, String balHomePath, HashSet<PackageID> alreadyImportedSet) {
        for (BPackageSymbol importSymbol : imports) {
            PackageID pkgId = importSymbol.pkgID;
            ExecutableJar jar = buildContext.moduleDependencyPathMap.get(pkgId);
            if (!alreadyImportedSet.contains(pkgId)) {
                alreadyImportedSet.add(pkgId);
                if (jar == null) {
                    jar = new ExecutableJar();
                    buildContext.moduleDependencyPathMap.put(pkgId, jar);
                }
                this.copyImportedLib(buildContext, importSymbol, sourceRootPath, balHomePath, jar.moduleLibs);
                this.copyImportedLibs(importSymbol.imports, jar.moduleLibs, buildContext, sourceRootPath, balHomePath, alreadyImportedSet);
            }
            moduleDependencySet.addAll(jar.moduleLibs);
        }
    }

    private void copyImportedLib(BuildContext buildContext, BPackageSymbol importz, Path project, String balHomePath, Set<Path> moduleDependencySet) {
        for (String platform : this.supportedPlatforms) {
            Path importJar = CopyNativeLibTask.findImportBaloPath(buildContext, importz, project, platform);
            if (importJar == null || !Files.exists(importJar, new LinkOption[0])) continue;
            this.copyLibsFromBalo(importJar, moduleDependencySet);
            return;
        }
        List libraries = this.manifest.getPlatform().libraries;
        if (libraries != null && libraries.size() > 0) {
            for (Library library : libraries) {
                if (library.getGroupId() == null || library.getModules() == null || library.getPath() == null || !library.getGroupId().equals(importz.pkgID.orgName.value) || !Arrays.asList(library.getModules()).contains(importz.pkgID.name.value)) continue;
                Path libFilePath = Paths.get(library.getPath(), new String[0]);
                Path libFile = project.resolve(libFilePath);
                Path libFileName = libFilePath.getFileName();
                if (libFileName == null) continue;
                Path path = Paths.get(libFile.toUri());
                moduleDependencySet.add(path);
                return;
            }
        }
        this.copyDependenciesFromToml(importz, balHomePath, moduleDependencySet);
    }

    private static Path findImportBaloPath(BuildContext buildContext, BPackageSymbol importz, Path project, String platform) {
        PackageID id = importz.pkgID;
        Optional<Dependency> importPathDependency = buildContext.getImportPathDependency(id);
        if (ProjectDirs.isModuleExist((Path)project, (String)id.name.value)) {
            return buildContext.getBaloFromTarget(id);
        }
        if (importPathDependency.isPresent()) {
            return importPathDependency.get().getMetadata().getPath();
        }
        return buildContext.getBaloFromHomeCache(id, platform);
    }

    private void copyLibsFromBalo(Path baloFilePath, Set<Path> moduleDependencySet) {
        String fileName = baloFilePath.getFileName().toString();
        Path baloFileUnzipDirectory = Paths.get(baloFilePath.getParent().toString(), fileName.substring(0, fileName.lastIndexOf(".")));
        File destFile = baloFileUnzipDirectory.toFile();
        if (!destFile.mkdir()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(destFile.toString(), new String[0]));){
                for (Path path : stream) {
                    moduleDependencySet.add(path);
                }
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("unable to copy native jar: " + e.getMessage()));
            }
            return;
        }
        try (JarFile jar = new JarFile(baloFilePath.toFile());){
            Enumeration<JarEntry> enumEntries = jar.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                String entryName = file.getName();
                if (!entryName.endsWith(".jar") || !entryName.contains("platform-libs")) continue;
                File f = Paths.get(baloFileUnzipDirectory.toString(), entryName.split("platform-libs")[1]).toFile();
                if (!f.exists()) {
                    try (InputStream is = jar.getInputStream(file);){
                        Files.copy(is, f.toPath(), new CopyOption[0]);
                    }
                }
                moduleDependencySet.add(f.toPath());
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("unable to copy native jar: " + e.getMessage()));
        }
    }

    private void copyDependenciesFromToml(BPackageSymbol importz, String balHomePath, Set<Path> moduleDependencySet) {
        PackageID id = importz.pkgID;
        String version = "0.0.0";
        if (!id.version.value.equals("")) {
            version = id.version.value;
        }
        if (this.skipCopyLibsFromDist) {
            return;
        }
        File tomlfile = Paths.get(balHomePath, "bir-cache", id.orgName.value, id.name.value, version, "Ballerina.toml").toFile();
        if (!tomlfile.exists()) {
            return;
        }
        Toml tomlConfig = new Toml().read(tomlfile);
        Toml platform = tomlConfig.getTable("platform");
        if (platform == null) {
            return;
        }
        List libraries = platform.getList("libraries");
        if (libraries == null) {
            return;
        }
        for (Object lib : libraries) {
            Path fileName = Paths.get(((HashMap)lib).get("path").toString(), new String[0]).getFileName();
            Path libPath = Paths.get(balHomePath, "bre", "lib", fileName.toString());
            moduleDependencySet.add(libPath);
        }
    }
}

