/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ballerinalang.cli.module.Push;
import org.ballerinalang.cli.module.TokenUpdater;
import org.ballerinalang.cli.module.exeptions.CommandException;
import org.ballerinalang.packerina.BrowserLauncher;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.DependencyMetadata;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.model.Proxy;
import org.ballerinalang.toml.model.Settings;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;
import org.wso2.ballerinalang.util.RepoUtils;
import org.wso2.ballerinalang.util.TomlParserUtils;

public class PushUtils {
    private static final String BALLERINA_CENTRAL_CLI_TOKEN = PushUtils.getBallerinaCentralCliTokenUrl();
    private static final Path BALLERINA_HOME_PATH = RepoUtils.createAndGetHomeReposPath();
    private static final Path SETTINGS_TOML_FILE_PATH = BALLERINA_HOME_PATH.resolve("Settings.toml");
    private static Settings settings;
    private static final PrintStream SYS_ERR;
    private static List<String> supportedPlatforms;
    private static java.net.Proxy proxy;
    private static TrustManager[] trustAllCerts;

    public static void pushModules(List<String> moduleNames, Path sourceRootPath) {
        try {
            Map<Path, List<Dependency>> balosWithDependencies = PushUtils.validateBalos(moduleNames, sourceRootPath);
            PushUtils.recursivelyPushBalos(balosWithDependencies);
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("unexpected error occurred when trying to push to remote repository: " + RepoUtils.getRemoteRepoURL()));
        }
    }

    private static void pushBaloToRemote(Path baloPath) {
        block4: {
            Path baloFileName = baloPath.getFileName();
            if (null != baloFileName) {
                Manifest manifest = RepoUtils.getManifestFromBalo((Path)baloPath.toAbsolutePath());
                String moduleName = baloFileName.toString().split("-")[0];
                String orgName = manifest.getProject().getOrgName();
                String version = manifest.getProject().getVersion();
                String accessToken = PushUtils.checkAccessToken();
                Proxy proxy = settings.getProxy();
                String urlWithModulePath = RepoUtils.getRemoteRepoURL() + "/modules/";
                try {
                    Push.execute((String)urlWithModulePath, (String)proxy.getHost(), (int)proxy.getPort(), (String)proxy.getUserName(), (String)proxy.getPassword(), (String)accessToken, (String)orgName, (String)moduleName, (String)version, (Path)baloPath.toAbsolutePath());
                }
                catch (CommandException e) {
                    String errorMessage = e.getMessage();
                    if (null == errorMessage || "".equals(errorMessage.trim())) break block4;
                    if (errorMessage.contains("\n\tat")) {
                        errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n\tat"));
                    }
                    errorMessage = errorMessage.replaceAll("error: ", "");
                    throw LauncherUtils.createLauncherException((String)("unexpected error occurred while pushing module '" + moduleName + "' to remote repository(" + RepoUtils.getRemoteRepoURL() + "): " + errorMessage));
                }
            }
        }
    }

    private static Map<Path, List<Dependency>> validateBalos(List<String> moduleNames, Path sourceRootPath) throws IOException {
        HashMap<Path, List<Dependency>> balos = new HashMap<Path, List<Dependency>>();
        for (String string : moduleNames) {
            Optional<Path> moduleBaloFile;
            Path baloOutputDir = Paths.get(sourceRootPath.toString(), "target", "balo");
            if (Files.notExists(baloOutputDir, new LinkOption[0])) {
                throw LauncherUtils.createLauncherException((String)("cannot find balo file for the module: " + string + ". Run 'ballerina build -c <module_name>' to compile and generate the balo."));
            }
            try (Stream<Path> baloFilesStream = Files.list(baloOutputDir);){
                moduleBaloFile = baloFilesStream.filter(baloFile -> null != baloFile.getFileName() && baloFile.getFileName().toString().startsWith(moduleName + "-" + "2020r1")).findFirst();
            }
            if (!moduleBaloFile.isPresent()) {
                throw LauncherUtils.createLauncherException((String)("cannot find balo file for the module: " + string + ". Run 'ballerina build -c <module_name>' to compile and generate the balo."));
            }
            Path baloFilePath = moduleBaloFile.get();
            Manifest manifest = RepoUtils.getManifestFromBalo((Path)baloFilePath.toAbsolutePath());
            if (!RepoUtils.validateOrg((String)manifest.getProject().getOrgName())) {
                throw LauncherUtils.createLauncherException((String)("invalid organization name provided '" + manifest.getProject().getOrgName() + "'. Only lowercase alphanumerics and underscores are allowed in an organization name and the maximum length is 256 characters"));
            }
            if (!RepoUtils.validatePkg((String)string)) {
                throw LauncherUtils.createLauncherException((String)("invalid module name provided '" + string + "'. Only alphanumerics, underscores and periods are allowed in a module name and the maximum length is 256 characters"));
            }
            if (!RepoUtils.validatePkg((String)string)) {
                throw LauncherUtils.createLauncherException((String)("invalid module name provided '" + string + "'. Only alphanumerics, underscores and periods are allowed in a module name and the maximum length is 256 characters"));
            }
            List dependenciesWithBaloPath = manifest.getDependencies().stream().filter(dep -> dep.getMetadata().getPath() != null).map(Dependency::getModuleID).collect(Collectors.toList());
            if (dependenciesWithBaloPath.size() > 0) {
                throw LauncherUtils.createLauncherException((String)("dependencies cannot be given by path when pushing module(s) to remote. check dependencies in Ballerina.toml: [" + String.join((CharSequence)", ", dependenciesWithBaloPath) + "]"));
            }
            Dependency moduleAsDependency = new Dependency();
            moduleAsDependency.setModuleID(manifest.getProject().getOrgName() + "/" + string);
            DependencyMetadata depMetadata = new DependencyMetadata();
            depMetadata.setVersion(manifest.getProject().getVersion());
            moduleAsDependency.setMetadata(depMetadata);
            if (PushUtils.isDependencyAvailableInRemote(moduleAsDependency)) {
                throw LauncherUtils.createLauncherException((String)("module '" + moduleAsDependency.toString() + "' already exists in remote repository(" + RepoUtils.getRemoteRepoURL() + "). build and push after updating the version in the Ballerina.toml."));
            }
            balos.put(baloFilePath, manifest.getDependencies());
        }
        for (Map.Entry entry : balos.entrySet()) {
            Path baloFileName = ((Path)entry.getKey()).getFileName();
            if (null == baloFileName) continue;
            String moduleName = baloFileName.toString().split("-")[0];
            Manifest manifest = RepoUtils.getManifestFromBalo((Path)((Path)entry.getKey()).toAbsolutePath());
            Iterator dependencies = ((List)entry.getValue()).iterator();
            while (dependencies.hasNext()) {
                Dependency dependency = (Dependency)dependencies.next();
                if (("ballerina".equals(dependency.getOrgName()) || "ballerinax".equals(dependency.getOrgName()) || dependency.getOrgName().equals(manifest.getProject().getOrgName())) && (!dependency.getOrgName().equals(manifest.getProject().getOrgName()) || ProjectDirs.isModuleExist((Path)sourceRootPath, (String)dependency.getModuleName()))) continue;
                if (!PushUtils.isDependencyAvailableInRemote(dependency)) {
                    throw LauncherUtils.createLauncherException((String)("'" + dependency.toString() + "' which is a dependency of module '" + moduleName + "' cannot be found in remote repository(" + RepoUtils.getRemoteRepoURL() + ")"));
                }
                dependencies.remove();
            }
        }
        return balos;
    }

    private static void recursivelyPushBalos(Map<Path, List<Dependency>> balos) throws IOException {
        if (balos.size() == 0) {
            return;
        }
        for (List<Dependency> deps : balos.values()) {
            Iterator<Dependency> depsIterator = deps.iterator();
            while (depsIterator.hasNext()) {
                Dependency dep = depsIterator.next();
                if (PushUtils.isDependencyAvailableInRemote(dep)) {
                    depsIterator.remove();
                }
                if (!"ballerina".equals(dep.getOrgName()) && !"ballerinax".equals(dep.getOrgName())) continue;
                depsIterator.remove();
            }
        }
        Optional<List> baloWithAllDependenciesAvailableInCentral = balos.values().stream().filter(depList -> depList.size() == 0).findAny();
        if (!baloWithAllDependenciesAvailableInCentral.isPresent()) {
            Set unresolvedDependencies = balos.values().stream().flatMap(Collection::stream).map(Dependency::toString).collect(Collectors.toSet());
            throw LauncherUtils.createLauncherException((String)("unable to find dependencies in remote repository: [" + String.join((CharSequence)", ", unresolvedDependencies) + "]"));
        }
        Iterator<Map.Entry<Path, List<Dependency>>> iterator = balos.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Path, List<Dependency>> baloDeps = iterator.next();
            if (baloDeps.getValue().size() != 0) continue;
            PushUtils.pushBaloToRemote(baloDeps.getKey());
            iterator.remove();
        }
        PushUtils.recursivelyPushBalos(balos);
    }

    private static boolean isDependencyAvailableInRemote(Dependency dep) throws IOException {
        URI baseURI = URI.create(RepoUtils.getRemoteRepoURL() + "/modules/");
        String moduleUrl = baseURI.toString() + dep.getOrgName() + "/" + dep.getModuleName();
        if (null != dep.getMetadata() && null != dep.getMetadata().getVersion() && !dep.getMetadata().getVersion().isEmpty()) {
            moduleUrl = moduleUrl + "/" + dep.getMetadata().getVersion();
        }
        for (String supportedPlatform : supportedPlatforms) {
            HttpURLConnection conn = null == proxy ? (HttpURLConnection)URI.create(moduleUrl).toURL().openConnection() : (HttpURLConnection)URI.create(moduleUrl).toURL().openConnection(proxy);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Ballerina-Platform", supportedPlatform);
            conn.setRequestProperty("Ballerina-Language-Specification-Version", "2020r1");
            int statusCode = conn.getResponseCode();
            if (statusCode == 302) {
                return true;
            }
            if (statusCode == 400) {
                BufferedReader errorStream = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                Throwable throwable = null;
                try {
                    try {
                        String errorContent = errorStream.lines().collect(Collectors.joining("\n"));
                        throw LauncherUtils.createLauncherException((String)("error: could not connect to remote repository to find module: " + dep.toString() + ". reason: " + errorContent));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (errorStream != null) {
                        if (throwable != null) {
                            try {
                                errorStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            errorStream.close();
                        }
                    }
                    throw throwable3;
                }
            }
            if (statusCode == 500) {
                throw LauncherUtils.createLauncherException((String)("error: could not connect to remote repository to find module: " + dep.toString() + "."));
            }
            conn.disconnect();
            Authenticator.setDefault(null);
        }
        return false;
    }

    private static String checkAccessToken() {
        String accessToken = PushUtils.getAccessTokenOfCLI();
        if (accessToken.isEmpty()) {
            try {
                SYS_ERR.println("Opening the web browser to " + BALLERINA_CENTRAL_CLI_TOKEN + " for auto token update ...");
                BrowserLauncher.startInDefaultBrowser(BALLERINA_CENTRAL_CLI_TOKEN);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("Access token is missing in " + SETTINGS_TOML_FILE_PATH.toString() + "\nAuto update failed. Please visit https://central.ballerina.io"));
            }
            long modifiedTimeOfFileAtStart = PushUtils.getLastModifiedTimeOfFile(SETTINGS_TOML_FILE_PATH);
            TokenUpdater.execute((String)SETTINGS_TOML_FILE_PATH.toString());
            boolean waitForToken = true;
            while (waitForToken) {
                PushUtils.pause();
                long modifiedTimeOfFileAfter = PushUtils.getLastModifiedTimeOfFile(SETTINGS_TOML_FILE_PATH);
                if (modifiedTimeOfFileAtStart == modifiedTimeOfFileAfter) continue;
                accessToken = PushUtils.getAccessTokenOfCLI();
                if (accessToken.isEmpty()) {
                    throw LauncherUtils.createLauncherException((String)("Access token is missing in " + SETTINGS_TOML_FILE_PATH.toString() + "\nPlease visit https://central.ballerina.io"));
                }
                waitForToken = false;
            }
        }
        return accessToken;
    }

    private static void pause() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            throw LauncherUtils.createLauncherException((String)"Error occurred while retrieving the access token");
        }
    }

    private static long getLastModifiedTimeOfFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return -1L;
        }
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException ex) {
            throw LauncherUtils.createLauncherException((String)("Error occurred when reading file for token " + SETTINGS_TOML_FILE_PATH.toString()));
        }
    }

    private static String getAccessTokenOfCLI() {
        settings = TomlParserUtils.readSettings();
        String tokenAsEnvVar = System.getenv("BALLERINA_CENTRAL_ACCESS_TOKEN");
        if (tokenAsEnvVar != null) {
            return tokenAsEnvVar;
        }
        if (settings.getCentral() != null) {
            return settings.getCentral().getAccessToken();
        }
        return "";
    }

    public static void pushAllModules(Path sourceRootPath) {
        try {
            List<String> fileList;
            try (Stream<Path> moduleDirsStream = Files.list(sourceRootPath.resolve("src"));){
                fileList = moduleDirsStream.filter(path -> Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)).map(ProjectDirs::getLastComp).filter(dirName -> !PushUtils.isSpecialDirectory(dirName)).map(Path::toString).collect(Collectors.toList());
            }
            if (fileList.size() == 0) {
                throw LauncherUtils.createLauncherException((String)("no modules found to push in " + sourceRootPath.toString()));
            }
            PushUtils.pushModules(fileList, sourceRootPath);
        }
        catch (IOException ex) {
            throw LauncherUtils.createLauncherException((String)("error occurred while pushing modules from " + sourceRootPath.toString() + " " + ex.getMessage()));
        }
    }

    private static boolean isSpecialDirectory(Path dirName) {
        List<String> ignoreDirs = Arrays.asList("target", "resources");
        String dirNameStr = dirName.toString();
        return dirNameStr.startsWith(".") || dirName.toFile().isHidden() || ignoreDirs.contains(dirNameStr);
    }

    private static java.net.Proxy getProxy() {
        Proxy proxy = TomlParserUtils.readSettings().getProxy();
        if (!"".equals(proxy.getHost())) {
            InetSocketAddress proxyInet = new InetSocketAddress(proxy.getHost(), proxy.getPort());
            if (!"".equals(proxy.getUserName()) && "".equals(proxy.getPassword())) {
                RemoteAuthenticator authenticator = new RemoteAuthenticator();
                Authenticator.setDefault(authenticator);
            }
            return new java.net.Proxy(Proxy.Type.HTTP, proxyInet);
        }
        return null;
    }

    private static String getBallerinaCentralCliTokenUrl() {
        if (RepoUtils.SET_BALLERINA_STAGE_CENTRAL) {
            return "https://staging-central.ballerina.io/cli-token";
        }
        if (RepoUtils.SET_BALLERINA_DEV_CENTRAL) {
            return "https://dev-central.ballerina.io/cli-token";
        }
        return "https://central.ballerina.io/cli-token";
    }

    static {
        SYS_ERR = System.err;
        supportedPlatforms = Arrays.stream(ProgramFileConstants.SUPPORTED_PLATFORMS).collect(Collectors.toList());
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            supportedPlatforms.add("any");
            proxy = PushUtils.getProxy();
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
    }

    static class RemoteAuthenticator
    extends Authenticator {
        Proxy proxy = TomlParserUtils.readSettings().getProxy();

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.proxy.getUserName(), this.proxy.getPassword().toCharArray());
        }
    }
}

