/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.packerina.TaskExecutor;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.packerina.task.CleanTargetDirTask;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import picocli.CommandLine;

@CommandLine.Command(name="clean", description={"Ballerina clean - Cleans out the target directory of a project."})
public class CleanCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private boolean exitWhenFinish;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--sourceroot"}, description={"Path to the directory containing the ballerina project"})
    private String sourceRootPath;

    public CleanCommand(Path sourceRoot, boolean exitWhenFinish) {
        this.sourceRootPath = sourceRoot.toAbsolutePath().toString();
        this.outStream = System.out;
        this.exitWhenFinish = exitWhenFinish;
    }

    public CleanCommand() {
        this.sourceRootPath = Paths.get(System.getProperty("user.dir"), new String[0]).toString();
        this.outStream = System.out;
        this.exitWhenFinish = true;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"clean");
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (ProjectDirs.isProject((Path)Paths.get(this.sourceRootPath, new String[0]))) {
            TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask()).build();
            BuildContext buildContext = new BuildContext(Paths.get(this.sourceRootPath, new String[0]));
            taskExecutor.executeTasks(buildContext);
            if (this.exitWhenFinish) {
                Runtime.getRuntime().exit(0);
            }
        } else {
            this.outStream.println("'clean' command can only be executed for a Ballerina project.");
            CommandUtil.exitError(this.exitWhenFinish);
        }
    }

    public String getName() {
        return "clean";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Cleans the \"target\" directory of a Ballerina project. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append(" ballerina clean \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

