/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleFileContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SourceType;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.packerina.utils.FileUtils;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class CopyExecutableTask
implements Task {
    private Path outputPath;

    public CopyExecutableTask(Path outputPath) {
        this.outputPath = outputPath;
    }

    @Override
    public void execute(BuildContext buildContext) {
        try {
            for (BLangPackage module : buildContext.getModules()) {
                Path executableFile = buildContext.getExecutablePathFromTarget(module.packageID);
                Path sourceRoot = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
                if (this.outputPath.isAbsolute()) {
                    if (Files.isDirectory(this.outputPath, new LinkOption[0])) {
                        Path executableFileName;
                        if (Files.notExists(this.outputPath, new LinkOption[0])) {
                            Files.createDirectories(this.outputPath, new FileAttribute[0]);
                        }
                        if (null != (executableFileName = executableFile.getFileName())) {
                            this.outputPath = this.outputPath.resolve(executableFileName.toString());
                        }
                    } else if (!this.outputPath.toString().endsWith(".jar")) {
                        this.outputPath = Paths.get(this.outputPath.toString() + ".jar", new String[0]);
                    }
                } else {
                    this.outputPath = FileUtils.hasExtension(this.outputPath) ? sourceRoot.resolve(this.outputPath) : sourceRoot.resolve(this.outputPath + ".jar");
                }
                Files.copy(executableFile, this.outputPath, StandardCopyOption.REPLACE_EXISTING);
                Path executableDir = this.outputPath.getParent();
                if (null == executableDir) continue;
                buildContext.updateExecutableDir(executableDir);
                if (SourceType.SINGLE_BAL_FILE != buildContext.getSourceType()) continue;
                SingleFileContext singleFileContext = (SingleFileContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
                singleFileContext.setExecutableFilePath(this.outputPath);
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("unable to copying executable: " + e.getMessage()));
        }
    }
}

