/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.util.Map;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.Flags;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.StringValue;

public class MapUtils {
    public static void handleMapStore(MapValue<StringValue, Object> mapValue, StringValue fieldName, Object value) {
        BType mapType = mapValue.getType();
        switch (mapType.getTag()) {
            case 15: {
                if (!TypeChecker.checkIsType(value, ((BMapType)mapType).getConstrainedType())) {
                    BType expType = ((BMapType)mapType).getConstrainedType();
                    BType valuesType = TypeChecker.getType(value);
                    throw BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_MAP_INSERTION, expType, valuesType));
                }
                mapValue.put(fieldName, value);
                break;
            }
            case 12: {
                BType recFieldType;
                BRecordType recType = (BRecordType)mapType;
                BField recField = recType.getFields().get(fieldName.getValue());
                if (recField != null) {
                    recFieldType = recField.type;
                } else if (recType.restFieldType != null) {
                    recFieldType = recType.restFieldType;
                } else {
                    throw BallerinaErrors.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ACCESS, fieldName.getValue(), recType));
                }
                if (!TypeChecker.checkIsType(value, recFieldType)) {
                    BType valuesType = TypeChecker.getType(value);
                    throw BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ADDITION, fieldName.getValue(), recFieldType, valuesType));
                }
                mapValue.put(fieldName, value);
            }
        }
    }

    @Deprecated
    public static void handleMapStore(MapValue<String, Object> mapValue, String fieldName, Object value) {
        BType mapType = mapValue.getType();
        switch (mapType.getTag()) {
            case 15: {
                if (!TypeChecker.checkIsType(value, ((BMapType)mapType).getConstrainedType())) {
                    BType expType = ((BMapType)mapType).getConstrainedType();
                    BType valuesType = TypeChecker.getType(value);
                    throw BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_MAP_INSERTION, expType, valuesType));
                }
                mapValue.put(fieldName, value);
                break;
            }
            case 12: {
                BType recFieldType;
                BRecordType recType = (BRecordType)mapType;
                BField recField = recType.getFields().get(fieldName);
                if (recField != null) {
                    recFieldType = recField.type;
                } else if (recType.restFieldType != null) {
                    recFieldType = recType.restFieldType;
                } else {
                    throw BallerinaErrors.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ACCESS, fieldName, recType));
                }
                if (!TypeChecker.checkIsType(value, recFieldType)) {
                    BType valuesType = TypeChecker.getType(value);
                    throw BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ADDITION, fieldName, recFieldType, valuesType));
                }
                mapValue.put(fieldName, value);
            }
        }
    }

    public static ErrorValue createOpNotSupportedError(BType type, String op) {
        return BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "OperationNotSupported"), String.format("%s not supported on type '%s'", op, type.getQualifiedName()));
    }

    public static void checkIsMapOnlyOperation(BType mapType, String op) {
        switch (mapType.getTag()) {
            case 7: 
            case 12: 
            case 15: {
                return;
            }
        }
        throw MapUtils.createOpNotSupportedError(mapType, op);
    }

    public static void validateRequiredFieldForRecord(MapValue<?, ?> m, String k) {
        BType type = m.getType();
        if (type.getTag() == 12 && MapUtils.isRequiredField((BRecordType)type, k)) {
            throw MapUtils.createOpNotSupportedErrorForRecord(type, k);
        }
    }

    public static void validateRecord(MapValue<?, ?> m) {
        BType type = m.getType();
        if (type.getTag() != 12) {
            return;
        }
        Map<String, BField> fields = ((BRecordType)type).getFields();
        for (String key : fields.keySet()) {
            if (!MapUtils.isRequiredField((BRecordType)type, key)) continue;
            throw MapUtils.createOpNotSupportedErrorForRecord(type, key);
        }
    }

    private static boolean isRequiredField(BRecordType type, String k) {
        Map<String, BField> fields = type.getFields();
        BField field = fields.get(k);
        return field != null && Flags.isFlagOn(field.flags, 256);
    }

    private static ErrorValue createOpNotSupportedErrorForRecord(BType type, String field) {
        return BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "OperationNotSupported"), String.format("failed to remove field: '%s' is a required field in '%s'", field, type.getQualifiedName()));
    }
}

