/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;

public class MathUtils {
    public static long divide(long numerator, long denominator) {
        try {
            if (numerator == Long.MIN_VALUE && denominator == -1L) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.NUMBER_OVERFLOW, " int range overflow");
            }
            return numerator / denominator;
        }
        catch (ArithmeticException e) {
            if (denominator == 0L) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.DIVISION_BY_ZERO_ERROR, " / by zero");
            }
            throw BallerinaErrors.createError(BallerinaErrorReasons.ARITHMETIC_OPERATION_ERROR, e.getMessage());
        }
    }

    public static long remainder(long numerator, long denominator) {
        try {
            return numerator % denominator;
        }
        catch (ArithmeticException e) {
            if (denominator == 0L) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.DIVISION_BY_ZERO_ERROR, " / by zero");
            }
            throw BallerinaErrors.createError(BallerinaErrorReasons.ARITHMETIC_OPERATION_ERROR, e.getMessage());
        }
    }
}

