/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.observability.BallerinaObserver;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.tracer.BSpan;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ErrorValue;

public class ObserveUtils {
    private static final List<BallerinaObserver> observers = new CopyOnWriteArrayList<BallerinaObserver>();
    private static final boolean enabled;
    private static final boolean metricsEnabled;
    private static final boolean tracingEnabled;

    public static void addObserver(BallerinaObserver observer) {
        observers.add(observer);
    }

    public static void startResourceObservation(Strand strand, String serviceName, String resourceName) {
        ObserverContext observerContext;
        if (!enabled) {
            return;
        }
        if (strand.observerContext != null) {
            observerContext = strand.observerContext;
        } else {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame(strand, observerContext);
        }
        if (serviceName == null) {
            serviceName = "Unknown Service";
            strand.setProperty("service_name", serviceName);
        }
        observerContext.setServiceName(serviceName);
        observerContext.setResourceName(resourceName);
        observerContext.setServer();
        observerContext.setStarted();
        observers.forEach(observer -> observer.startServerObservation(strand.observerContext));
        strand.setProperty("service_name", serviceName);
    }

    public static void stopObservation(Strand strand) {
        if (!enabled || strand.observerContext == null) {
            return;
        }
        ObserverContext observerContext = strand.observerContext;
        if (observerContext.isServer()) {
            observers.forEach(observer -> observer.stopServerObservation(observerContext));
        } else {
            observers.forEach(observer -> observer.stopClientObservation(observerContext));
            ObserveUtils.setObserverContextToCurrentFrame(strand, observerContext.getParent());
        }
        observerContext.setFinished();
    }

    public static void reportError(Strand strand, ErrorValue errorValue) {
        if (!enabled || strand.observerContext == null) {
            return;
        }
        ObserverContext observerContext = strand.observerContext;
        observers.forEach(observer -> {
            observerContext.addProperty("error", Boolean.TRUE);
            observerContext.addProperty("bstruct_error", errorValue);
        });
    }

    public static void startCallableObservation(Strand strand, String connectorName, String actionName) {
        if (!enabled) {
            return;
        }
        ObserverContext observerCtx = strand.observerContext;
        ObserverContext newObContext = new ObserverContext();
        newObContext.setParent(observerCtx);
        newObContext.setStarted();
        newObContext.setServiceName(observerCtx == null ? "Unknown Service" : observerCtx.getServiceName());
        newObContext.setConnectorName(connectorName);
        newObContext.setActionName(actionName);
        strand.observerContext = newObContext;
        observers.forEach(observer -> observer.startClientObservation(newObContext));
    }

    public static Map<String, String> getContextProperties(ObserverContext observerContext) {
        BSpan bSpan = (BSpan)observerContext.getProperty("_span_");
        if (bSpan != null) {
            return bSpan.getTraceContext();
        }
        return Collections.emptyMap();
    }

    public static void logMessageToActiveSpan(Strand strand, String logLevel, Supplier<String> logMessage, boolean isError) {
        if (!tracingEnabled) {
            return;
        }
        Optional<ObserverContext> observerContext = ObserveUtils.getObserverContextOfCurrentFrame(strand);
        if (!observerContext.isPresent()) {
            return;
        }
        BSpan span = (BSpan)observerContext.get().getProperty("_span_");
        if (span == null) {
            return;
        }
        HashMap<String, Object> logs = new HashMap<String, Object>(1);
        logs.put(logLevel, logMessage.get());
        if (!isError) {
            span.log(logs);
        } else {
            span.logError(logs);
        }
    }

    public static boolean isObservabilityEnabled() {
        return enabled;
    }

    public static boolean isMetricsEnabled() {
        return metricsEnabled;
    }

    public static boolean isTracingEnabled() {
        return tracingEnabled;
    }

    public static Optional<ObserverContext> getObserverContextOfCurrentFrame(Strand strand) {
        if (!enabled || strand.observerContext == null) {
            return Optional.empty();
        }
        return Optional.of(strand.observerContext);
    }

    public static void setObserverContextToCurrentFrame(Strand strand, ObserverContext observerContext) {
        if (!enabled) {
            return;
        }
        strand.observerContext = observerContext;
    }

    static {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        tracingEnabled = configRegistry.getAsBoolean("b7a.observability.tracing.enabled");
        metricsEnabled = configRegistry.getAsBoolean("b7a.observability.metrics.enabled");
        enabled = metricsEnabled || tracingEnabled;
    }
}

