/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.StreamValue;

public class BStreamType
extends BType {
    private BType constraint;

    BStreamType(String typeName, BType constraint, BPackage pkgPath) {
        super(typeName, pkgPath, StreamValue.class);
        this.constraint = constraint;
    }

    public BStreamType(BType constraint) {
        super("stream", null, StreamValue.class);
        this.constraint = constraint;
    }

    public BType getConstrainedType() {
        return this.constraint;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new StreamValue(this);
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 14;
    }

    @Override
    public String toString() {
        if (this.constraint == BTypes.typeAny) {
            return super.toString();
        }
        return "stream<" + this.constraint.getName() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BStreamType)) {
            return false;
        }
        BStreamType other = (BStreamType)obj;
        if (this.constraint == other.constraint) {
            return true;
        }
        if (this.constraint == null || other.constraint == null) {
            return false;
        }
        return this.constraint.equals(other.constraint);
    }
}

