/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.IteratorUtils;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public abstract class AbstractArrayValue
implements ArrayValue {
    static final int SYSTEM_ARRAY_MAX = 0x7FFFFFF7;
    protected volatile Status freezeStatus = new Status(State.UNFROZEN);
    protected int maxSize = 0x7FFFFFF7;
    protected static final int DEFAULT_ARRAY_SIZE = 100;
    protected int size = 0;
    protected BType iteratorNextReturnType;

    @Override
    public abstract Object get(long var1);

    @Override
    public abstract Object getRefValue(long var1);

    @Override
    public abstract long getInt(long var1);

    @Override
    public abstract boolean getBoolean(long var1);

    @Override
    public abstract byte getByte(long var1);

    @Override
    public abstract double getFloat(long var1);

    @Override
    @Deprecated
    public abstract String getString(long var1);

    @Override
    public abstract BString getBString(long var1);

    @Override
    public abstract void add(long var1, Object var3);

    @Override
    public abstract void add(long var1, long var3);

    @Override
    public abstract void add(long var1, boolean var3);

    @Override
    public abstract void add(long var1, byte var3);

    @Override
    public abstract void add(long var1, double var3);

    @Override
    @Deprecated
    public abstract void add(long var1, String var3);

    @Override
    public abstract void add(long var1, BString var3);

    @Override
    public void append(Object value) {
        this.add((long)this.size, value);
    }

    @Override
    public Object shift() {
        return this.shift(0L);
    }

    @Override
    public abstract Object shift(long var1);

    public void unshift(ArrayValue values) {
        this.unshift(0L, values);
    }

    @Override
    public void unshift(BArray values) {
        this.unshift(0L, (ArrayValue)values);
    }

    @Override
    public abstract String stringValue();

    @Override
    public abstract BType getType();

    @Override
    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public abstract Object copy(Map<Object, Object> var1);

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        ArrayValue copy = (ArrayValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public abstract void serialize(OutputStream var1);

    /*
     * Exception decompiling
     */
    @Override
    public String getJSONString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public abstract void attemptFreeze(Status var1);

    @Override
    public abstract void freezeDirect();

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    @Override
    public IteratorValue getIterator() {
        return new ArrayIterator(this);
    }

    @Override
    public void setLength(long length) {
        if (length == (long)this.size) {
            return;
        }
        this.handleFrozenArrayValue();
        int newLength = (int)length;
        this.checkFixedLength(length);
        this.rangeCheck(length, this.size);
        this.fillerValueCheck(newLength, this.size);
        this.resizeInternalArray(newLength);
        this.fillValues(newLength);
        this.size = newLength;
    }

    protected void initializeIteratorNextReturnType() {
        BType type;
        if (this.getType().getTag() == 20) {
            type = this.getElementType();
        } else {
            BTupleType tupleType = (BTupleType)this.getType();
            LinkedHashSet<BType> types = new LinkedHashSet<BType>(tupleType.getTupleTypes());
            if (tupleType.getRestType() != null) {
                types.add(tupleType.getRestType());
            }
            type = types.size() == 1 ? (BType)types.iterator().next() : new BUnionType(new ArrayList<BType>(types));
        }
        this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(type);
    }

    public BType getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.initializeIteratorNextReturnType();
        }
        return this.iteratorNextReturnType;
    }

    protected abstract void fillValues(int var1);

    protected abstract void fillerValueCheck(int var1, int var2);

    protected abstract void resizeInternalArray(int var1);

    protected abstract void rangeCheckForGet(long var1, int var3);

    protected abstract void rangeCheck(long var1, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFrozenArrayValue() {
        AbstractArrayValue abstractArrayValue = this;
        synchronized (abstractArrayValue) {
            try {
                if (this.freezeStatus.getState() != State.UNFROZEN) {
                    FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.array");
                }
            }
            catch (BLangFreezeException e) {
                throw BallerinaErrors.createError(e.getMessage(), e.getDetail());
            }
        }
    }

    protected void prepareForConsecutiveMultiAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.resetSize(intIndex);
    }

    protected abstract void ensureCapacity(int var1, int var2);

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    protected abstract void unshift(long var1, ArrayValue var3);

    protected abstract void checkFixedLength(long var1);

    static class ArrayIterator
    implements IteratorValue {
        ArrayValue array;
        long cursor = 0L;
        long length;

        ArrayIterator(ArrayValue value) {
            this.array = value;
            this.length = value.size();
        }

        public Object next() {
            long cursor;
            if ((cursor = this.cursor++) == this.length) {
                return null;
            }
            return this.array.get(cursor);
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }

        @Override
        public BString bStringValue() {
            return null;
        }
    }
}

