/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.types.BErrorType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.freeze.Status;
import org.ballerinalang.jvm.values.utils.StringUtils;

public class ErrorValue
extends BError
implements RefValue {
    private static final long serialVersionUID = 1L;
    private final BType type;
    private final BString reason;
    private final Object details;

    @Deprecated
    public ErrorValue(String reason, Object details) {
        this((BType)new BErrorType("error", BTypes.typeError.getPackage(), BTypes.typeString, TypeChecker.getType(details)), reason, details);
    }

    @Deprecated
    public ErrorValue(BType type, String reason, Object details) {
        super(reason);
        this.type = type;
        this.reason = org.ballerinalang.jvm.StringUtils.fromString(reason);
        this.details = details;
    }

    @Deprecated
    public ErrorValue(BString reason, Object details) {
        this((BType)new BErrorType("error", BTypes.typeError.getPackage(), BTypes.typeString, TypeChecker.getType(details)), reason, details);
    }

    @Deprecated
    public ErrorValue(BType type, BString reason, Object details) {
        super(reason);
        this.type = type;
        this.reason = reason;
        this.details = details;
    }

    @Override
    @Deprecated
    public String stringValue() {
        if (this.isEmptyDetail()) {
            return "error " + this.reason.getValue();
        }
        return "error " + this.reason.getValue() + " " + StringUtils.getStringValue(this.details);
    }

    @Override
    public BString bStringValue() {
        if (this.isEmptyDetail()) {
            return org.ballerinalang.jvm.StringUtils.fromString("error ").concat(this.reason);
        }
        return org.ballerinalang.jvm.StringUtils.fromString("error ").concat(this.reason).concat(org.ballerinalang.jvm.StringUtils.fromString(" ")).concat(StringUtils.getBStringValue(this.details));
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void attemptFreeze(Status freezeStatus) {
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public String toString() {
        return this.stringValue();
    }

    @Override
    @Deprecated
    public String getReason() {
        return this.reason.getValue();
    }

    public BString getErrorReason() {
        return this.reason;
    }

    @Override
    public Object getDetails() {
        if (this.details instanceof RefValue) {
            return ((RefValue)this.details).copy(new HashMap<Object, Object>());
        }
        return this.details;
    }

    @Override
    public void printStackTrace() {
        ErrorHandlerUtils.printError("error: " + this.getPrintableStackTrace());
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        printWriter.print("error: " + this.getPrintableStackTrace());
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTrace = super.getStackTrace();
        LinkedList filteredStack = new LinkedList();
        int index = 0;
        for (StackTraceElement stackFrame : stackTrace) {
            Optional<StackTraceElement> stackTraceElement = BallerinaErrors.filterStackTraceElement(stackFrame, index++);
            stackTraceElement.ifPresent(filteredStack::add);
        }
        StackTraceElement[] filteredStackArray = new StackTraceElement[filteredStack.size()];
        return filteredStack.toArray(filteredStackArray);
    }

    @Override
    public String getPrintableStackTrace() {
        String errorMsg = this.getErrorMessage();
        StringBuilder sb = new StringBuilder();
        sb.append(errorMsg);
        StackTraceElement[] stackTrace = this.getStackTrace();
        if (stackTrace.length == 0) {
            return sb.toString();
        }
        sb.append("\n\tat ");
        this.printStackElement(sb, stackTrace[0], "");
        for (int i = 1; i < stackTrace.length; ++i) {
            this.printStackElement(sb, stackTrace[i], "\n\t   ");
        }
        return sb.toString();
    }

    private void printStackElement(StringBuilder sb, StackTraceElement stackTraceElement, String tab) {
        String pkgName = stackTraceElement.getClassName();
        String fileName = stackTraceElement.getFileName();
        fileName = fileName.replace(".bal", "");
        fileName = fileName.replace("/", "-");
        pkgName = pkgName.replace("." + fileName, "");
        sb.append(tab);
        if (!pkgName.equals("___init")) {
            sb.append(pkgName).append(":");
        }
        sb.append(stackTraceElement.getMethodName());
        sb.append("(").append(stackTraceElement.getFileName());
        sb.append(":").append(stackTraceElement.getLineNumber()).append(")");
    }

    private String getErrorMessage() {
        String errorMsg = "";
        boolean reasonAdded = false;
        if (this.reason != null && this.reason.length() != 0) {
            errorMsg = this.reason.getValue();
            reasonAdded = true;
        }
        if (this.details != null) {
            errorMsg = errorMsg + (reasonAdded ? " " : "") + this.details.toString();
        }
        return errorMsg;
    }

    private boolean isEmptyDetail() {
        if (this.details == null) {
            return true;
        }
        return this.details instanceof MapValue && ((MapValue)this.details).isEmpty();
    }

    @Override
    public boolean isFrozen() {
        return true;
    }
}

