/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;

public abstract class ValueCreator {
    private static final Map<String, ValueCreator> runtimeValueCreators = new HashMap<String, ValueCreator>();

    public static void addValueCreator(String orgName, String moduleName, String moduleVersion, ValueCreator valueCreator) {
        String key = ValueCreator.getLookupKey(orgName, moduleName, moduleVersion);
        if (!key.equals(".") && runtimeValueCreators.containsKey(key)) {
            return;
        }
        runtimeValueCreators.put(key, valueCreator);
    }

    private static String getLookupKey(String orgName, String moduleName, String version) {
        if (".".equals(moduleName)) {
            return moduleName;
        }
        String pkgName = "";
        if (orgName != null && !orgName.equals("$anon")) {
            pkgName = orgName + "/";
        }
        if (version == null || version.equals("")) {
            return pkgName + moduleName;
        }
        return pkgName + moduleName + ":" + version;
    }

    public static ValueCreator getValueCreator(String key) {
        if (!runtimeValueCreators.containsKey(key)) {
            throw new BallerinaException("Value creator object is not available");
        }
        return runtimeValueCreators.get(key);
    }

    public abstract MapValue<String, Object> createRecordValue(String var1);

    public abstract ObjectValue createObjectValue(String var1, Scheduler var2, Strand var3, Map<String, Object> var4, Object[] var5);
}

