/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaXMLSerializer;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.XMLValidator;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.XMLPi;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLText;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BXML;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public final class XMLItem
extends XMLValue {
    public static final String XMLNS_URL_PREFIX = "{http://www.w3.org/2000/xmlns/}";
    private QName name;
    private XMLSequence children;
    private MapValue<String, String> attributes;
    private List<WeakReference<XMLItem>> probableParents;

    public XMLItem(QName name, XMLSequence children) {
        this.name = name;
        this.children = children;
        for (BXML child : children.children) {
            this.addParent(child, this);
        }
        this.attributes = new MapValueImpl<String, String>(new BMapType(BTypes.typeString));
        this.probableParents = new ArrayList<WeakReference<XMLItem>>();
    }

    public XMLItem(QName name) {
        this(name, new XMLSequence(new ArrayList<BXML>()));
    }

    @Override
    public XMLNodeType getNodeType() {
        return XMLNodeType.ELEMENT;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public String getElementName() {
        return this.name.toString();
    }

    public QName getQName() {
        return this.name;
    }

    public void setQName(QName name) {
        this.name = name;
    }

    @Override
    public String getTextValue() {
        return this.children.getTextValue();
    }

    @Override
    public String getAttribute(String localName, String namespace) {
        return this.getAttribute(localName, namespace, "");
    }

    @Override
    public String getAttribute(String localName, String namespace, String prefix) {
        if (prefix != null && !prefix.isEmpty()) {
            String ns = (String)this.attributes.get(XMLNS_URL_PREFIX + prefix);
            String attrVal = (String)this.attributes.get("{" + ns + "}" + localName);
            if (attrVal != null) {
                return attrVal;
            }
        }
        if (namespace != null && !namespace.isEmpty()) {
            return (String)this.attributes.get("{" + namespace + "}" + localName);
        }
        String defaultNS = (String)this.attributes.get("{http://www.w3.org/2000/xmlns/}xmlns");
        if (defaultNS != null) {
            return (String)this.attributes.get("{" + defaultNS + "}" + localName);
        }
        return (String)this.attributes.get(localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String localName, String namespaceUri, String prefix, String value) {
        String ns;
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (localName == null || localName.isEmpty()) {
            throw BallerinaErrors.createError("localname of the attribute cannot be empty");
        }
        XMLValidator.validateXMLName(localName);
        XMLValidator.validateXMLName(prefix);
        if (namespaceUri == null && prefix != null && prefix.equals("xmlns") || localName.equals("xmlns")) {
            String nsNameDecl = XMLNS_URL_PREFIX + localName;
            this.attributes.put(nsNameDecl, value);
            return;
        }
        String nsOfPrefix = (String)this.attributes.get(XMLNS_URL_PREFIX + prefix);
        if (namespaceUri != null && nsOfPrefix != null && !namespaceUri.equals(nsOfPrefix)) {
            String errorMsg = String.format("failed to add attribute '%s:%s'. prefix '%s' is already bound to namespace '%s'", prefix, localName, prefix, nsOfPrefix);
            throw BallerinaErrors.createError(errorMsg);
        }
        if ((namespaceUri == null || namespaceUri.isEmpty()) && (ns = (String)this.attributes.get("{http://www.w3.org/2000/xmlns/}xmlns")) != null) {
            namespaceUri = ns;
        }
        QName qname = this.getQName(localName, namespaceUri, prefix);
        this.attributes.put(qname.toString(), value);
        if (prefix != null && prefix.equals("xmlns")) {
            String xmlnsPrefix = XMLNS_URL_PREFIX + prefix;
            this.attributes.put(xmlnsPrefix, namespaceUri);
        }
    }

    @Override
    public MapValue<String, String> getAttributesMap() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(BMap<String, ?> attributes) {
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        for (String qname : attributes.getKeys()) {
            String uri;
            String localName;
            if (qname.startsWith("{") && qname.indexOf(125) > 0) {
                localName = qname.substring(qname.indexOf(125) + 1, qname.length());
                uri = qname.substring(1, qname.indexOf(125));
            } else {
                localName = qname;
                uri = BLangConstants.STRING_NULL_VALUE;
            }
            XMLValidator.validateXMLName(localName);
            this.setAttribute(localName, uri, BLangConstants.STRING_NULL_VALUE, attributes.get(qname).toString());
        }
    }

    @Override
    public XMLValue elements() {
        ArrayList<BXML> children = new ArrayList<BXML>();
        children.add(this);
        return new XMLSequence(children);
    }

    @Override
    public XMLValue elements(String qname) {
        ArrayList<BXML> children = new ArrayList<BXML>();
        if (this.getElementName().equals(this.getQname(qname).toString())) {
            children.add(this);
        }
        return new XMLSequence(children);
    }

    @Override
    public XMLValue children() {
        return new XMLSequence(new ArrayList<BXML>(this.children.getChildrenList()));
    }

    @Override
    public XMLValue children(String qname) {
        return this.children.elements(qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChildren(BXML seq) {
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (seq == null) {
            return;
        }
        if (seq.getNodeType() == XMLNodeType.SEQUENCE) {
            this.children = (XMLSequence)seq;
            for (BXML child : this.children.children) {
                this.addParent(child);
            }
        } else {
            this.addParent(seq);
            this.children = new XMLSequence(seq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void addChildren(BXML seq) {
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN || this.children.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (seq == null) {
            return;
        }
        ArrayList<BXML> leftList = new ArrayList<BXML>(this.children.children);
        if (seq.getNodeType() == XMLNodeType.SEQUENCE) {
            List<BXML> appendingList = ((XMLSequence)seq).getChildrenList();
            if (this.isLastChildIsTextNode(leftList) && !appendingList.isEmpty() && appendingList.get(0).getNodeType() == XMLNodeType.TEXT) {
                this.mergeAdjoiningTextNodesIntoList(leftList, appendingList);
            } else {
                for (BXML bxml : appendingList) {
                    this.addParent(bxml, this);
                }
                leftList.addAll(appendingList);
            }
        } else {
            this.addParent(seq, this);
            leftList.add(seq);
        }
        this.children = new XMLSequence(leftList);
    }

    private void addParent(BXML child) {
        this.ensureAcyclicGraph(child, this);
        this.addParent(child, this);
    }

    private void addParent(BXML child, XMLItem thisElem) {
        if (child.getNodeType() == XMLNodeType.ELEMENT) {
            ((XMLItem)child).probableParents.add(new WeakReference<XMLItem>(thisElem));
        }
    }

    private void ensureAcyclicGraph(BXML newSubTree, XMLItem current) {
        for (WeakReference<XMLItem> probableParentRef : current.probableParents) {
            XMLItem parent = (XMLItem)probableParentRef.get();
            if (!parent.children.children.contains(current)) continue;
            if (parent == newSubTree) {
                throw this.createXMLCycleError();
            }
            this.ensureAcyclicGraph(newSubTree, parent);
        }
    }

    private BallerinaException createXMLCycleError() {
        return new BallerinaException(BallerinaErrorReasons.XML_OPERATION_ERROR, "Cycle detected");
    }

    private void mergeAdjoiningTextNodesIntoList(List leftList, List<BXML> appendingList) {
        XMLPi lastChild = (XMLPi)leftList.get(leftList.size() - 1);
        String firstChildContent = ((XMLPi)appendingList.get(0)).getData();
        String mergedTextContent = lastChild.getData() + firstChildContent;
        XMLText text = new XMLText(mergedTextContent);
        leftList.set(leftList.size() - 1, text);
        for (int i = 1; i < appendingList.size(); ++i) {
            leftList.add(appendingList.get(i));
        }
    }

    private boolean isLastChildIsTextNode(List<BXML> childList) {
        return !childList.isEmpty() && childList.get(childList.size() - 1).getNodeType() == XMLNodeType.TEXT;
    }

    @Override
    public XMLValue strip() {
        this.children.strip();
        return this;
    }

    @Override
    public XMLValue slice(long startIndex, long endIndex) {
        return this;
    }

    @Override
    public XMLValue descendants(List<String> qnames) {
        if (qnames.contains(this.getQName().toString())) {
            List<BXML> descendants = Arrays.asList(this);
            this.addDescendants(descendants, this, qnames);
            return new XMLSequence(descendants);
        }
        return this.children.descendants((List)qnames);
    }

    public OMNode value() {
        try {
            String xmlStr = this.stringValue();
            OMElement omElement = XMLFactory.stringToOM(xmlStr);
            return omElement;
        }
        catch (ErrorValue e) {
            throw e;
        }
        catch (XMLStreamException | OMException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw BallerinaErrors.createError(cause.getMessage());
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError("failed to parse xml: " + e.getMessage());
        }
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    @Deprecated
    public String stringValue() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BallerinaXMLSerializer ballerinaXMLSerializer = new BallerinaXMLSerializer(outputStream);
            ballerinaXMLSerializer.write(this);
            ballerinaXMLSerializer.flush();
            String xml = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            ballerinaXMLSerializer.close();
            return xml;
        }
        catch (Throwable t) {
            XMLItem.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public BString bStringValue() {
        String text = this.stringValue();
        return text == BLangConstants.STRING_NULL_VALUE ? null : StringUtils.fromString(text);
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        QName elemName = new QName(this.name.getNamespaceURI(), this.name.getLocalPart(), this.name.getPrefix());
        XMLItem xmlItem = new XMLItem(elemName, (XMLSequence)this.children.copy(refs));
        BMap attributesMap = xmlItem.getAttributesMap();
        MapValue copy = (MapValue)this.getAttributesMap().copy(refs);
        if (attributesMap instanceof MapValueImpl) {
            MapValueImpl map = (MapValueImpl)attributesMap;
            map.putAll((Map)((Object)copy));
        } else {
            for (Map.Entry entry : copy.entrySet()) {
                attributesMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.getAttributesMap().isFrozen()) {
            attributesMap.freeze();
        }
        return xmlItem;
    }

    @Override
    public XMLValue getItem(int index) {
        if (index != 0) {
            return new XMLSequence();
        }
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    public int length() {
        return 1;
    }

    @Override
    public void build() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String qname) {
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        this.attributes.remove(qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChildren(String qname) {
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        List<BXML> children = this.children.children;
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int i = 0; i < children.size(); ++i) {
            BXML child = children.get(i);
            if (child.getNodeType() != XMLNodeType.ELEMENT || !((XMLItem)child).getElementName().equals(qname)) continue;
            toRemove.add(i);
        }
        Collections.reverse(toRemove);
        for (Integer index : toRemove) {
            BXML removed = children.remove(index);
            this.removeParentReference(removed);
        }
    }

    private void removeParentReference(BXML removedItem) {
        if (removedItem.getNodeType() != XMLNodeType.ELEMENT) {
            return;
        }
        XMLItem item = (XMLItem)removedItem;
        Iterator<WeakReference<XMLItem>> iterator = item.probableParents.iterator();
        while (iterator.hasNext()) {
            WeakReference<XMLItem> probableParent = iterator.next();
            XMLItem parent = (XMLItem)probableParent.get();
            if (parent != this) continue;
            probableParent.clear();
            iterator.remove();
        }
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
        }
        this.children.attemptFreeze(freezeStatus);
        this.attributes.attemptFreeze(freezeStatus);
    }

    @Override
    public void freezeDirect() {
        this.freezeStatus.setFrozen();
        this.children.freezeDirect();
        this.attributes.freezeDirect();
    }

    private QName getQName(String localName, String namespaceUri, String prefix) {
        QName qname = prefix != null ? new QName(namespaceUri, localName, prefix) : new QName(namespaceUri, localName);
        return qname;
    }

    public XMLSequence getChildrenSeq() {
        return this.children;
    }

    @Override
    public IteratorValue getIterator() {
        final XMLItem that = this;
        return new IteratorValue(){
            boolean read = false;

            @Override
            public BString bStringValue() {
                return that.bStringValue();
            }

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            public Object next() {
                if (this.read) {
                    throw new NoSuchElementException();
                }
                this.read = true;
                return that;
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XMLItem) {
            XMLItem that = (XMLItem)obj;
            boolean qNameEquals = that.getQName().equals(this.getQName());
            if (!qNameEquals) {
                return false;
            }
            boolean attrMapEquals = that.attributes.entrySet().equals(this.attributes.entrySet());
            if (!attrMapEquals) {
                return false;
            }
            return that.children.equals(this.children);
        }
        if (obj instanceof XMLSequence) {
            XMLSequence other = (XMLSequence)obj;
            if (other.children.size() == 1 && this.equals(other.children.get(0))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public BType getType() {
        return BTypes.typeElement;
    }
}

