/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Map;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMProcessingInstructionImpl;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.XMLNonElementItem;
import org.ballerinalang.jvm.values.api.BString;

public class XMLPi
extends XMLNonElementItem {
    private String data;
    private String target;

    public XMLPi(String data, String target) {
        this.data = data;
        this.target = target;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public String getTextValue() {
        return "";
    }

    public String getData() {
        return this.data;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public XMLNodeType getNodeType() {
        return XMLNodeType.PI;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new XMLPi(this.data, this.target);
    }

    @Override
    public OMNode value() {
        OMProcessingInstructionImpl pi = new OMProcessingInstructionImpl();
        pi.setTarget(this.target);
        pi.setValue(this.data);
        return pi;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XMLPi) {
            XMLPi that = (XMLPi)obj;
            return this.data.equals(that.data) && this.target.equals(that.target);
        }
        return false;
    }

    @Override
    public String stringValue() {
        return "<?" + this.target + " " + this.data + "?>";
    }

    @Override
    public BString bStringValue() {
        return StringUtils.fromString(this.stringValue());
    }

    @Override
    public BType getType() {
        return BTypes.typeProcessingInstruction;
    }
}

