/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.siddhi.annotation.classindex;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public final class ClassFilter {
    private ClassFilter() {
    }

    public static UnionBuilder only() {
        return new Builder();
    }

    public static FilterBuilder any(final Predicate ... alternatives) {
        return new CommonFilterBuilder(){

            @Override
            public boolean matches(Class<?> klass) {
                for (Predicate alternative : alternatives) {
                    if (!alternative.matches(klass)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static class Builder
    extends CommonFilterBuilder
    implements UnionBuilder {
        private final List<Predicate> predicates = new ArrayList<Predicate>();

        private Builder() {
        }

        @Override
        public Builder satisfying(Predicate predicate) {
            this.predicates.add(predicate);
            return this;
        }

        @Override
        public Builder topLevel() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    return klass.getEnclosingClass() == null;
                }
            });
        }

        @Override
        public UnionBuilder topLevelOrStaticNested() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    return klass.getEnclosingClass() == null || (klass.getModifiers() & 8) != 0;
                }
            });
        }

        @Override
        public Builder enclosedIn(final Class<?> enclosing) {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    do {
                        if ((klass = klass.getEnclosingClass()) != null) continue;
                        return false;
                    } while (!enclosing.equals(klass));
                    return true;
                }
            });
        }

        @Override
        public UnionBuilder enclosedDirectlyIn(final Class<?> enclosing) {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    if ((klass = klass.getEnclosingClass()) == null) {
                        return false;
                    }
                    return klass == enclosing;
                }
            });
        }

        @Override
        public Builder annotatedWith(final Class<? extends Annotation> annotation) {
            Retention retention = annotation.getAnnotation(Retention.class);
            if (retention == null || retention.value() != RetentionPolicy.RUNTIME) {
                throw new IllegalStateException("Cannot filter annotated with annotation without retention policy set to RUNTIME: " + annotation.getName());
            }
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    return klass.isAnnotationPresent(annotation);
                }
            });
        }

        @Override
        public UnionBuilder withModifiers(final int modifiers) {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    return (klass.getModifiers() & modifiers) != 0;
                }
            });
        }

        @Override
        public UnionBuilder withoutModifiers(final int modifiers) {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    return (klass.getModifiers() & modifiers) == 0;
                }
            });
        }

        @Override
        public UnionBuilder withPublicDefaultConstructor() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    try {
                        Constructor<?> constructor = klass.getConstructor(new Class[0]);
                        return (constructor.getModifiers() & 1) != 0;
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        return false;
                    }
                }
            });
        }

        @Override
        public UnionBuilder interfaces() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    return klass.isInterface();
                }
            });
        }

        @Override
        public UnionBuilder classes() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> klass) {
                    return !klass.isInterface();
                }
            });
        }

        @Override
        public boolean matches(Class<?> klass) {
            for (Predicate predicate : this.predicates) {
                if (predicate.matches(klass)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class CommonFilterBuilder
    implements FilterBuilder {
        private CommonFilterBuilder() {
        }

        @Override
        public <T> Iterable<Class<? extends T>> from(Iterable<Class<? extends T>> classes) {
            ArrayList<Class<T>> result = new ArrayList<Class<T>>();
            for (Class<T> clazz : classes) {
                if (!this.matches(clazz)) continue;
                result.add(clazz);
            }
            return result;
        }
    }

    public static interface UnionBuilder
    extends FilterBuilder {
        public UnionBuilder satisfying(Predicate var1);

        public UnionBuilder topLevel();

        public UnionBuilder topLevelOrStaticNested();

        public UnionBuilder enclosedIn(Class<?> var1);

        public UnionBuilder enclosedDirectlyIn(Class<?> var1);

        public UnionBuilder annotatedWith(Class<? extends Annotation> var1);

        public UnionBuilder withModifiers(int var1);

        public UnionBuilder withoutModifiers(int var1);

        public UnionBuilder withPublicDefaultConstructor();

        public UnionBuilder interfaces();

        public UnionBuilder classes();
    }

    public static interface FilterBuilder
    extends Predicate {
        public <T> Iterable<Class<? extends T>> from(Iterable<Class<? extends T>> var1);
    }

    public static interface Predicate {
        public boolean matches(Class<?> var1);
    }
}

