/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.test.runtime.entity.Test;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.testerina.core.TesterinaRegistry;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

@SupportedAnnotationPackages(value={"ballerina/test"})
public class TestAnnotationProcessor
extends AbstractCompilerPlugin {
    private static final String TEST_ANNOTATION_NAME = "Config";
    private static final String BEFORE_SUITE_ANNOTATION_NAME = "BeforeSuite";
    private static final String AFTER_SUITE_ANNOTATION_NAME = "AfterSuite";
    private static final String BEFORE_EACH_ANNOTATION_NAME = "BeforeEach";
    private static final String AFTER_EACH_ANNOTATION_NAME = "AfterEach";
    private static final String MOCK_ANNOTATION_NAME = "Mock";
    private static final String BEFORE_FUNCTION = "before";
    private static final String AFTER_FUNCTION = "after";
    private static final String DEPENDS_ON_FUNCTIONS = "dependsOn";
    private static final String MODULE = "moduleName";
    private static final String FUNCTION = "functionName";
    private static final String GROUP_ANNOTATION_NAME = "groups";
    private static final String VALUE_SET_ANNOTATION_NAME = "dataProvider";
    private static final String TEST_ENABLE_ANNOTATION_NAME = "enable";
    private static final String MOCK_ANNOTATION_DELIMITER = "#";
    private static final String MOCK_FN_DELIMITER = "~";
    private TesterinaRegistry registry = TesterinaRegistry.getInstance();
    private boolean enabled = true;
    private CompilerContext compilerContext;
    private DiagnosticLog diagnosticLog;
    private Types typeChecker;
    private SymbolResolver symbolResolver;
    private BLangPackage parent;
    private PackageCache packageCache;
    private Map<BPackageSymbol, SymbolEnv> packageEnvironmentMap;

    public void init(DiagnosticLog diagnosticLog) {
        this.diagnosticLog = diagnosticLog;
        this.packageEnvironmentMap = SymbolTable.getInstance((CompilerContext)this.compilerContext).pkgEnvMap;
        this.packageCache = PackageCache.getInstance((CompilerContext)this.compilerContext);
        this.typeChecker = Types.getInstance((CompilerContext)this.compilerContext);
        this.symbolResolver = SymbolResolver.getInstance((CompilerContext)this.compilerContext);
        if (TesterinaRegistry.getInstance().isTestSuitesCompiled()) {
            this.enabled = false;
        }
    }

    public void setCompilerContext(CompilerContext context) {
        this.compilerContext = context;
    }

    public void process(FunctionNode functionNode, List<AnnotationAttachmentNode> annotations) {
        if (!this.enabled) {
            return;
        }
        this.parent = (BLangPackage)((BLangFunction)functionNode).parent;
        String packageName = this.getPackageName((PackageNode)this.parent);
        TestSuite suite = this.registry.getTestSuites().get(packageName);
        if (suite == null) {
            suite = this.registry.getTestSuites().computeIfAbsent(packageName, func -> new TestSuite(this.parent.packageID.name.value, packageName, this.parent.packageID.orgName.value, this.parent.packageID.version.value));
        }
        annotations = annotations.stream().distinct().collect(Collectors.toList());
        for (AnnotationAttachmentNode annotationAttachmentNode : annotations) {
            String annotationName = annotationAttachmentNode.getAnnotationName().getValue();
            String functionName = functionNode.getName().getValue();
            if (BEFORE_SUITE_ANNOTATION_NAME.equals(annotationName)) {
                suite.addBeforeSuiteFunction(functionName);
                continue;
            }
            if (AFTER_SUITE_ANNOTATION_NAME.equals(annotationName)) {
                suite.addAfterSuiteFunction(functionName);
                continue;
            }
            if (BEFORE_EACH_ANNOTATION_NAME.equals(annotationName)) {
                suite.addBeforeEachFunction(functionName);
                continue;
            }
            if (AFTER_EACH_ANNOTATION_NAME.equals(annotationName)) {
                suite.addAfterEachFunction(functionName);
                continue;
            }
            if (TEST_ANNOTATION_NAME.equals(annotationName)) {
                Test test = new Test();
                test.setTestName(functionName);
                AtomicBoolean shouldSkip = new AtomicBoolean();
                AtomicBoolean groupsFound = new AtomicBoolean();
                List<String> groups = this.registry.getGroups();
                boolean shouldIncludeGroups = this.registry.shouldIncludeGroups();
                if (annotationAttachmentNode.getExpression() instanceof BLangRecordLiteral) {
                    List attributes = ((BLangRecordLiteral)annotationAttachmentNode.getExpression()).getFields();
                    attributes.forEach(field -> {
                        BLangListConstructorExpr values;
                        BLangRecordLiteral.BLangRecordVarNameField valueExpr;
                        String name;
                        if (field.isKeyValueField()) {
                            BLangRecordLiteral.BLangRecordKeyValueField attributeNode = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                            name = attributeNode.getKey().toString();
                            valueExpr = attributeNode.getValue();
                        } else {
                            BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                            name = varNameField.variableName.value;
                            valueExpr = varNameField;
                        }
                        if (TEST_ENABLE_ANNOTATION_NAME.equals(name) && "false".equals(valueExpr.toString())) {
                            shouldSkip.set(true);
                            return;
                        }
                        if (GROUP_ANNOTATION_NAME.equals(name) && valueExpr instanceof BLangListConstructorExpr) {
                            values = (BLangListConstructorExpr)valueExpr;
                            test.setGroups(values.exprs.stream().map(node -> node.toString()).collect(Collectors.toList()));
                            if (groups != null && !groups.isEmpty()) {
                                boolean isGroupPresent = this.isGroupAvailable(groups, test.getGroups());
                                if (shouldIncludeGroups) {
                                    if (!isGroupPresent) {
                                        shouldSkip.set(true);
                                        return;
                                    }
                                } else if (isGroupPresent) {
                                    shouldSkip.set(true);
                                    return;
                                }
                                groupsFound.set(true);
                            }
                        }
                        if (VALUE_SET_ANNOTATION_NAME.equals(name)) {
                            test.setDataProvider(valueExpr.toString());
                        }
                        if (BEFORE_FUNCTION.equals(name)) {
                            test.setBeforeTestFunction(valueExpr.toString());
                        }
                        if (AFTER_FUNCTION.equals(name)) {
                            test.setAfterTestFunction(valueExpr.toString());
                        }
                        if (DEPENDS_ON_FUNCTIONS.equals(name) && valueExpr instanceof BLangListConstructorExpr) {
                            values = (BLangListConstructorExpr)valueExpr;
                            values.exprs.stream().map(node -> node.toString()).forEach(arg_0 -> ((Test)test).addDependsOnTestFunction(arg_0));
                        }
                    });
                }
                if (groups != null && !groups.isEmpty() && !groupsFound.get() && shouldIncludeGroups) {
                    shouldSkip.set(true);
                }
                if (shouldSkip.get()) continue;
                suite.addTests(test);
                continue;
            }
            if (!MOCK_ANNOTATION_NAME.equals(annotationName)) continue;
            String[] vals = new String[2];
            vals[0] = packageName;
            if (annotationAttachmentNode.getExpression().getKind() != NodeKind.RECORD_LITERAL_EXPR) continue;
            List attributes = ((BLangRecordLiteral)annotationAttachmentNode.getExpression()).getFields();
            attributes.forEach(field -> {
                BLangRecordLiteral.BLangRecordVarNameField valueExpr;
                String name;
                if (field.isKeyValueField()) {
                    BLangRecordLiteral.BLangRecordKeyValueField attributeNode = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    name = attributeNode.getKey().toString();
                    valueExpr = attributeNode.getValue();
                } else {
                    BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                    name = varNameField.variableName.value;
                    valueExpr = varNameField;
                }
                String value = valueExpr.toString();
                if (MODULE.equals(name)) {
                    vals[0] = value = this.formatPackageName(value);
                } else if (FUNCTION.equals(name)) {
                    vals[1] = value;
                }
            });
            if (vals[1].isEmpty()) {
                this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)"function name cannot be empty");
                break;
            }
            PackageID functionToMockID = this.getPackageID(vals[0]);
            if (functionToMockID == null) {
                this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)"could not find module specified ");
            }
            BType functionToMockType = this.getFunctionType(this.packageEnvironmentMap, functionToMockID, vals[1]);
            BType mockFunctionType = this.getFunctionType(this.packageEnvironmentMap, this.parent.packageID, ((BLangFunction)functionNode).name.toString());
            if (functionToMockType != null && mockFunctionType != null) {
                if (!this.typeChecker.isAssignable(mockFunctionType, functionToMockType)) {
                    this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)((BLangFunction)functionNode).pos, (CharSequence)("incompatible types: expected " + functionToMockType.toString() + " but found " + mockFunctionType.toString()));
                }
            } else {
                this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)"could not find functions in module");
            }
            BLangTestablePackage bLangTestablePackage = (BLangTestablePackage)((BLangFunction)functionNode).parent;
            bLangTestablePackage.addMockFunction(functionToMockID + MOCK_FN_DELIMITER + vals[1], functionName);
        }
    }

    public void process(SimpleVariableNode simpleVariableNode, List<AnnotationAttachmentNode> annotations) {
        this.parent = (BLangPackage)((BLangSimpleVariable)simpleVariableNode).parent;
        String packageName = this.getPackageName((PackageNode)this.parent);
        annotations = annotations.stream().distinct().collect(Collectors.toList());
        for (AnnotationAttachmentNode annotationAttachmentNode : annotations) {
            String annotationName = annotationAttachmentNode.getAnnotationName().getValue();
            if (!MOCK_ANNOTATION_NAME.equals(annotationName)) continue;
            String type = ((BLangUserDefinedType)((BLangSimpleVariable)simpleVariableNode).typeNode).typeName.getValue();
            if (type.equals("MockFunction")) {
                String mockFnObjectName = simpleVariableNode.getName().getValue();
                String[] annotationValues = new String[2];
                annotationValues[0] = packageName;
                if (annotationAttachmentNode.getExpression().getKind() != NodeKind.RECORD_LITERAL_EXPR) continue;
                List fields = ((BLangRecordLiteral)annotationAttachmentNode.getExpression()).getFields();
                this.setAnnotationValues(fields, annotationValues, annotationAttachmentNode);
                PackageID functionToMockID = this.getPackageID(annotationValues[0]);
                this.validateFunctionName(annotationValues[1], functionToMockID, annotationAttachmentNode);
                BLangTestablePackage bLangTestablePackage = (BLangTestablePackage)((BLangSimpleVariable)simpleVariableNode).parent;
                bLangTestablePackage.addMockFunction(functionToMockID + MOCK_ANNOTATION_DELIMITER + annotationValues[1], mockFnObjectName);
                continue;
            }
            this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, annotationAttachmentNode.getPosition(), (CharSequence)"Annotation can only be attached to a test:MockFunction object");
        }
    }

    private void setAnnotationValues(List<RecordLiteralNode.RecordField> fields, String[] annotationValues, AnnotationAttachmentNode attachmentNode) {
        fields.forEach(field -> {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField attributeNode = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                String name = attributeNode.getKey().toString();
                BLangExpression valueExpr = attributeNode.getValue();
                String value = valueExpr.toString();
                if (MODULE.equals(name)) {
                    annotationValues[0] = value = this.formatPackageName(value);
                } else if (FUNCTION.equals(name)) {
                    annotationValues[1] = value;
                }
            } else {
                this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, attachmentNode.getPosition(), (CharSequence)"Annotation fields must be key-value pairs");
            }
        });
    }

    private PackageID getPackageID(String moduleName) {
        if (this.packageCache.getSymbol(moduleName) != null) {
            return this.packageCache.getSymbol((String)moduleName).pkgID;
        }
        return null;
    }

    private String formatPackageName(String value) {
        if (value.isEmpty() || value.equals(Names.DOT.value)) {
            value = this.parent.packageID.toString();
        } else if (!value.contains(Names.ORG_NAME_SEPARATOR.value) && !value.contains(Names.VERSION_SEPARATOR.value)) {
            value = new PackageID(this.parent.packageID.orgName, new Name(value), this.parent.packageID.version).toString();
        }
        return value;
    }

    private void validateFunctionName(String functionName, PackageID functionToMockID, AnnotationAttachmentNode attachmentNode) {
        if (functionToMockID == null) {
            this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, attachmentNode.getPosition(), (CharSequence)"could not find module specified ");
        } else if (functionName == null) {
            this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, attachmentNode.getPosition(), (CharSequence)"Function name cannot be empty");
        } else {
            for (Map.Entry<BPackageSymbol, SymbolEnv> entry : this.packageEnvironmentMap.entrySet()) {
                if (!entry.getKey().pkgID.equals((Object)functionToMockID) || !entry.getValue().scope.entries.containsKey(new Name(functionName))) continue;
                return;
            }
            this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, attachmentNode.getPosition(), (CharSequence)("Function '" + functionName + "' cannot be found in the package '" + functionToMockID.toString()));
        }
    }

    private boolean isGroupAvailable(List<String> inputGroups, List<String> functionGroups) {
        for (String group : inputGroups) {
            for (String funcGroup : functionGroups) {
                if (!group.equals(funcGroup)) continue;
                return true;
            }
        }
        return false;
    }

    private String getPackageName(PackageNode packageNode) {
        BLangPackage bLangPackage = (BLangPackage)packageNode;
        return bLangPackage.packageID.toString();
    }

    private BType getFunctionType(Map<BPackageSymbol, SymbolEnv> pkgEnvMap, PackageID packageID, String functionName) {
        for (Map.Entry<BPackageSymbol, SymbolEnv> entry : pkgEnvMap.entrySet()) {
            BSymbol symbol;
            if (!entry.getKey().pkgID.equals((Object)packageID) || (symbol = this.symbolResolver.lookupSymbolInMainSpace(entry.getValue(), new Name(functionName))).getType().toString().equals("other")) continue;
            return symbol.getType();
        }
        return null;
    }
}

