/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.test;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BErrorType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BFiniteType;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.util.exceptions.BLangRuntimeException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.testerina.natives.test.GenericMockObjectValue;
import org.ballerinalang.testerina.natives.test.MockConstants;
import org.ballerinalang.testerina.natives.test.MockRegistry;

public class Mock {
    public static Object mock(TypedescValue typedescValue, ObjectValue objectValue) {
        if (!objectValue.getType().getName().contains("$anonType$")) {
            if (objectValue.getType().getAttachedFunctions().length == 0 && objectValue.getType().getFields().size() == 0) {
                String detail = "mock object type '" + objectValue.getType().getName() + "' should have at least one member function or field declared.";
                return BallerinaErrors.createError((BType)Mock.getValidationErrorType("InvalidObjectError"), (String)"InvalidObjectError", (String)detail);
            }
            for (AttachedFunction attachedFunction : objectValue.getType().getAttachedFunctions()) {
                ErrorValue errorValue = Mock.validateFunctionSignatures(attachedFunction, ((BObjectType)typedescValue.getDescribingType()).getAttachedFunctions());
                if (errorValue == null) continue;
                return errorValue;
            }
            for (Map.Entry entry : objectValue.getType().getFields().entrySet()) {
                ErrorValue errorValue = Mock.validateField(entry, ((BObjectType)typedescValue.getDescribingType()).getFields());
                if (errorValue == null) continue;
                return errorValue;
            }
        }
        BObjectType bObjectType = (BObjectType)typedescValue.getDescribingType();
        return new GenericMockObjectValue(bObjectType, objectValue);
    }

    public static ErrorValue validatePreparedObj(ObjectValue caseObj) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj;
        ObjectValue mockObj = genericMock.getMockObj();
        String objectType = mockObj.getType().getName();
        if (!objectType.contains("$anonType$")) {
            String detail = "cases cannot be registered to user-defined object type '" + genericMock.getType().getName() + "'";
            return BallerinaErrors.createError((BType)Mock.getValidationErrorType("InvalidObjectError"), (String)"InvalidObjectError", (String)detail);
        }
        return null;
    }

    public static ErrorValue validateFunctionName(String functionName, ObjectValue mockObject) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)mockObject;
        if (!Mock.validateFunctionName(functionName, genericMock.getType().getAttachedFunctions())) {
            String detail = "invalid function name '" + functionName + " ' provided";
            return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionNotFoundError"), (String)"FunctionNotFoundError", (String)detail);
        }
        return null;
    }

    public static ErrorValue validateFieldName(String fieldName, ObjectValue mockObject) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)mockObject;
        if (!Mock.validateFieldName(fieldName, genericMock.getType().getFields())) {
            String detail = "invalid field name '" + fieldName + "' provided";
            return BallerinaErrors.createError((BType)Mock.getValidationErrorType("InvalidMemberFieldError"), (String)"InvalidMemberFieldError", (String)detail);
        }
        return null;
    }

    private static BErrorType getValidationErrorType(String errorTypeName) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        values.add("{ballerina/test}" + errorTypeName);
        BFiniteType reasonType = new BFiniteType("$anonType$reason", values, TypeFlags.asMask((int[])new int[]{2, 4}));
        BRecordType detailType = new BRecordType("Detail", MockConstants.TEST_PACKAGE_ID, TypeFlags.asMask((int[])new int[]{1}), false, TypeFlags.asMask((int[])new int[]{2, 4}));
        detailType.restFieldType = BTypes.typeAnydata;
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        fields.put("message", new BField(BTypes.typeString, "message", TypeFlags.asMask((int[])new int[]{1, 256})));
        fields.put("cause", new BField((BType)BTypes.typeError, "cause", TypeFlags.asMask((int[])new int[]{1, 8192})));
        detailType.setFields(fields);
        BErrorType bErrorType = new BErrorType(errorTypeName, MockConstants.TEST_PACKAGE_ID, (BType)reasonType, (BType)detailType);
        return bErrorType;
    }

    public static ErrorValue validateArguments(ObjectValue caseObj) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)caseObj.getObjectValue("mockObject");
        String functionName = caseObj.getStringValue("functionName");
        ArrayValue argsList = caseObj.getArrayValue("args");
        for (AttachedFunction attachedFunction : genericMock.getType().getAttachedFunctions()) {
            if (!attachedFunction.getName().equals(functionName)) continue;
            if (argsList.size() > attachedFunction.type.getParameterType().length) {
                String detail = "too many argument provided to mock the function " + functionName + "()";
                return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail);
            }
            int i = 0;
            IteratorValue it = argsList.getIterator();
            while (it.hasNext()) {
                Object arg = it.next();
                if (!"__ANY__".equals(arg)) {
                    if (attachedFunction.type.getParameterType()[i] instanceof BUnionType) {
                        boolean isTypeAvailable = false;
                        List memberTypes = ((BUnionType)attachedFunction.type.getParameterType()[i]).getMemberTypes();
                        for (BType memberType : memberTypes) {
                            if (!TypeChecker.checkIsType((Object)arg, (BType)memberType)) continue;
                            isTypeAvailable = true;
                            break;
                        }
                        if (!isTypeAvailable) {
                            String detail = "incorrect type of argument provided at position '" + (i + 1) + "' to mock the function " + functionName + "()";
                            return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail);
                        }
                    } else if (!TypeChecker.checkIsType((Object)arg, (BType)attachedFunction.type.getParameterType()[i])) {
                        String detail = "incorrect type of argument provided at position '" + (i + 1) + "' to mock the function " + functionName + "()";
                        return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail);
                    }
                }
                ++i;
            }
            break;
        }
        return null;
    }

    public static ErrorValue thenReturn(ObjectValue caseObj) {
        String functionName;
        GenericMockObjectValue genericMock = (GenericMockObjectValue)((Object)caseObj.get("mockObject"));
        ObjectValue mockObj = genericMock.getMockObj();
        Object returnVal = caseObj.get("returnValue");
        try {
            functionName = caseObj.getStringValue("functionName");
        }
        catch (BLangRuntimeException e) {
            if (!e.getMessage().contains("No such field or method: functionName")) {
                throw e;
            }
            functionName = null;
        }
        if (functionName != null) {
            ArrayValue args = caseObj.getArrayValue("args");
            if (!Mock.validateReturnValue(functionName, returnVal, genericMock.getType().getAttachedFunctions())) {
                String detail = "return value provided does not match the return type of function " + functionName + "()";
                return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail);
            }
            MockRegistry.getInstance().registerCase(mockObj, functionName, args, returnVal);
        } else {
            String fieldName = caseObj.getStringValue("fieldName");
            if (!Mock.validateFieldValue(returnVal, ((BField)genericMock.getType().getFields().get(fieldName)).getFieldType())) {
                String detail = "return value provided does not match the type of '" + fieldName + "'";
                return BallerinaErrors.createError((BType)Mock.getValidationErrorType("InvalidMemberFieldError"), (String)"InvalidMemberFieldError", (String)detail);
            }
            MockRegistry.getInstance().registerCase(mockObj, fieldName, null, returnVal);
        }
        return null;
    }

    public static ErrorValue thenReturnSequence(ObjectValue caseObj) {
        GenericMockObjectValue genericMock = (GenericMockObjectValue)((Object)caseObj.get("mockObject"));
        ObjectValue mockObj = genericMock.getMockObj();
        String functionName = caseObj.getStringValue("functionName");
        ArrayValue returnVals = caseObj.getArrayValue("returnValueSeq");
        for (int i = 0; i < returnVals.getValues().length && returnVals.getValues()[i] != null; ++i) {
            if (!Mock.validateReturnValue(functionName, returnVals.getValues()[i], genericMock.getType().getAttachedFunctions())) {
                String details = "return value provided at position '" + i + "' does not match the return type of function " + functionName + "()";
                return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)details);
            }
            MockRegistry.getInstance().registerCase(mockObj, functionName, null, returnVals.getValues()[i], i + 1);
        }
        return null;
    }

    private static boolean validateFunctionName(String functionName, AttachedFunction[] attachedFunctions) {
        for (AttachedFunction attachedFunction : attachedFunctions) {
            if (!attachedFunction.getName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    private static boolean validateFieldName(String fieldName, Map<String, BField> fieldMap) {
        for (Map.Entry<String, BField> field : fieldMap.entrySet()) {
            if (!field.getKey().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean validateReturnValue(String functionName, Object returnVal, AttachedFunction[] attachedFunctions) {
        for (AttachedFunction attachedFunction : attachedFunctions) {
            if (!attachedFunction.getName().equals(functionName)) continue;
            if (attachedFunction.type.getReturnParameterType() instanceof BUnionType) {
                List memberTypes = ((BUnionType)attachedFunction.type.getReturnParameterType()).getMemberTypes();
                for (BType memberType : memberTypes) {
                    if (!TypeChecker.checkIsType((Object)returnVal, (BType)memberType)) continue;
                    return true;
                }
                continue;
            }
            return TypeChecker.checkIsType((Object)returnVal, (BType)attachedFunction.type.getReturnParameterType());
        }
        return false;
    }

    private static boolean validateFieldValue(Object returnVal, BType fieldType) {
        return TypeChecker.checkIsType((Object)returnVal, (BType)fieldType);
    }

    private static ErrorValue validateFunctionSignatures(AttachedFunction func, AttachedFunction[] attachedFunctions) {
        String functionName = func.getName();
        BType[] paramTypes = func.getParameterType();
        BType returnType = func.type.getReturnParameterType();
        for (AttachedFunction attachedFunction : attachedFunctions) {
            if (!attachedFunction.getName().equals(functionName)) continue;
            if (paramTypes.length != attachedFunction.getParameterType().length) {
                String detail = "incorrect number of parameters provided for function " + functionName + "()";
                return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail);
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                String detail;
                if (attachedFunction.getParameterType()[i] instanceof BUnionType) {
                    if (!(paramTypes[i] instanceof BUnionType)) {
                        detail = "incompatible parameter type provided at position " + (i + 1) + " in function " + functionName + "(). parameter should be of union type ";
                        return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail);
                    }
                    BType[] memberTypes = ((BUnionType)attachedFunction.getParameterType()[i]).getMemberTypes().toArray(new BType[0]);
                    BType[] providedTypes = ((BUnionType)paramTypes[i]).getMemberTypes().toArray(new BType[0]);
                    for (int j = 0; j < memberTypes.length; ++j) {
                        if (TypeChecker.checkIsType((BType)providedTypes[j], (BType)memberTypes[j])) continue;
                        String detail2 = "incompatible parameter type provided at position " + (i + 1) + " in function " + functionName + "()";
                        return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail2);
                    }
                    continue;
                }
                if (TypeChecker.checkIsType((BType)paramTypes[i], (BType)attachedFunction.getParameterType()[i])) continue;
                detail = "incompatible parameter type provided at position " + (i + 1) + " in function " + functionName + "()";
                return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail);
            }
            if (!TypeChecker.checkIsType((BType)returnType, (BType)attachedFunction.type.getReturnParameterType())) {
                String detail = "incompatible return type provided for function " + functionName + "()";
                return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionSignatureMismatchError"), (String)"FunctionSignatureMismatchError", (String)detail);
            }
            return null;
        }
        String detail = "invalid function '" + functionName + "' provided";
        return BallerinaErrors.createError((BType)Mock.getValidationErrorType("FunctionNotFoundError"), (String)"FunctionNotFoundError", (String)detail);
    }

    private static ErrorValue validateField(Map.Entry<String, BField> mockField, Map<String, BField> fieldMap) {
        for (Map.Entry<String, BField> field : fieldMap.entrySet()) {
            if (!field.getKey().equals(mockField.getKey())) continue;
            if (TypeChecker.checkIsType((BType)field.getValue().getFieldType(), (BType)mockField.getValue().getFieldType())) {
                return null;
            }
            String detail = "incompatible field type '" + mockField.getValue().getFieldType() + "' provided for field " + mockField.getKey() + "";
            return BallerinaErrors.createError((BType)Mock.getValidationErrorType("InvalidMemberFieldError"), (String)"InvalidMemberFieldError", (String)detail);
        }
        String detail = "invalid field '" + mockField.getKey() + "' provided";
        return BallerinaErrors.createError((BType)Mock.getValidationErrorType("InvalidMemberFieldError"), (String)"InvalidMemberFieldError", (String)detail);
    }
}

