/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.idlj.IdljTranslator;

class BuiltInTranslator
extends IdljTranslator {
    private static final String AIX_IDLJ_COMPILER_NAME = "com.ibm.idl.toJavaPortable.Compile";
    private static final String ORACLE_IDLJ_COMPILER_NAME = "com.sun.tools.corba.se.idl.toJavaPortable.Compile";
    private static final String USE_GLASSFISH_IDL = " Built-in IDL compiler not available in JDK9. Use the glassfish compiler instead.";
    private static final String IDL_COMPILER_NOT_AVAILABLE = " IDL compiler not available";

    BuiltInTranslator() {
    }

    @Override
    void invokeCompiler(List<String> args) throws MojoExecutionException {
        Class<?> compilerClass = BuiltInTranslator.getCompilerClass();
        this.invokeCompiler(compilerClass, args);
    }

    private static Class<?> getCompilerClass() throws MojoExecutionException {
        try {
            return BuiltInTranslator.getClassLoaderFacade().loadClass(BuiltInTranslator.getIDLCompilerClassName());
        }
        catch (ClassNotFoundException e) {
            try {
                BuiltInTranslator.addToolsJarToPath();
                return BuiltInTranslator.getClassLoaderFacade().loadClass(BuiltInTranslator.getIDLCompilerClassName());
            }
            catch (Exception e2) {
                throw new MojoExecutionException(BuiltInTranslator.getSecondTryMessage(e2), (Exception)e);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(IDL_COMPILER_NOT_AVAILABLE, e);
        }
    }

    private static String getSecondTryMessage(Exception e) {
        return BuiltInTranslator.builtInCompilerHidden(e) ? USE_GLASSFISH_IDL : IDL_COMPILER_NOT_AVAILABLE;
    }

    private static boolean builtInCompilerHidden(Exception e) {
        return BuiltInTranslator.compilerNotFound(e) && BuiltInTranslator.isJigsawPresent();
    }

    private static boolean compilerNotFound(Exception e) {
        return e instanceof ClassNotFoundException;
    }

    private static boolean isJigsawPresent() {
        return !System.getProperty("java.version").startsWith("1.");
    }

    private static void addToolsJarToPath() throws MalformedURLException, ClassNotFoundException {
        File javaHome = new File(System.getProperty("java.home"));
        File toolsJar = new File(javaHome, "../lib/tools.jar");
        URL toolsJarUrl = toolsJar.toURI().toURL();
        BuiltInTranslator.getClassLoaderFacade().prependUrls(toolsJarUrl);
        System.setProperty("java.class.path", System.getProperty("java.class.path") + System.getProperty("path.separator") + toolsJar.getAbsolutePath());
        if (System.getProperty("java.vm.name").contains("HotSpot")) {
            BuiltInTranslator.getClassLoaderFacade().loadClass("com.sun.tools.corba.se.idl.som.cff.FileLocator");
        }
    }

    private static String getIDLCompilerClassName() {
        return BuiltInTranslator.isAix() ? AIX_IDLJ_COMPILER_NAME : ORACLE_IDLJ_COMPILER_NAME;
    }

    private static boolean isAix() {
        return System.getProperty("java.vm.vendor").contains("IBM");
    }
}

