/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.Commandline;
import org.codehaus.mojo.keytool.AbstractKeyToolRequestMojo;
import org.codehaus.mojo.keytool.requests.KeyToolImportKeystoreRequest;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="importKeystore", requiresProject=true, threadSafe=true)
public class ImportKeystoreMojo
extends AbstractKeyToolRequestMojo<KeyToolImportKeystoreRequest> {
    @Parameter
    private String srckeystore;
    @Parameter
    private String destkeystore;
    @Parameter
    private String srcstoretype;
    @Parameter
    private String deststoretype;
    @Parameter
    private String srcstorepass;
    @Parameter
    private String deststorepass;
    @Parameter
    private boolean srcprotected;
    @Parameter
    private String srcprovidername;
    @Parameter
    private String destprovidername;
    @Parameter
    private String srcalias;
    @Parameter
    private String destalias;
    @Parameter
    private String srckeypass;
    @Parameter
    private String destkeypass;
    @Parameter
    private boolean noprompt;
    @Parameter
    private String providerclass;
    @Parameter
    private String providerarg;
    @Parameter
    private String providerpath;
    @Parameter
    private boolean skipIfExist;

    public ImportKeystoreMojo() {
        super(KeyToolImportKeystoreRequest.class);
    }

    @Override
    public void execute() throws MojoExecutionException {
        File destinationKeystoreFile;
        boolean keystoreFileExists;
        if (this.skipIfExist && (keystoreFileExists = (destinationKeystoreFile = new File(this.destkeystore)).exists())) {
            this.getLog().info((CharSequence)("Skip execution, keystore already exists at " + destinationKeystoreFile));
            this.setSkip(true);
        }
        super.execute();
    }

    @Override
    protected KeyToolImportKeystoreRequest createKeytoolRequest() {
        KeyToolImportKeystoreRequest request = (KeyToolImportKeystoreRequest)super.createKeytoolRequest();
        request.setSrckeystore(this.srckeystore);
        request.setDestkeystore(this.destkeystore);
        request.setSrcstoretype(this.srcstoretype);
        request.setDeststoretype(this.deststoretype);
        request.setSrcstorepass(this.srcstorepass);
        request.setDeststorepass(this.deststorepass);
        request.setSrcprotected(this.srcprotected);
        request.setSrcprovidername(this.srcprovidername);
        request.setDestprovidername(this.destprovidername);
        request.setSrcalias(this.srcalias);
        request.setDestalias(this.destalias);
        request.setSrckeypass(this.srckeypass);
        request.setDestkeypass(this.destkeypass);
        request.setNoprompt(this.noprompt);
        request.setProviderclass(this.providerclass);
        request.setProviderarg(this.providerarg);
        request.setProviderpath(this.providerpath);
        return request;
    }

    @Override
    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo = super.getCommandlineInfo(commandLine);
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.srckeypass, (String)"'*****'");
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.destkeypass, (String)"'*****'");
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.srcstorepass, (String)"'*****'");
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.deststorepass, (String)"'*****'");
        return commandLineInfo;
    }
}

