/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.utils.SonarException;

@Properties(value={@Property(key="sonar.pmd.generateXml", defaultValue="false", name="Generate XML Report", project=false, global=false)})
public class PmdConfiguration
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(PmdConfiguration.class);
    public static final String PROPERTY_GENERATE_XML = "sonar.pmd.generateXml";
    public static final String PMD_RESULT_XML = "pmd-result.xml";
    private final ProjectFileSystem projectFileSystem;
    private final Settings settings;

    public PmdConfiguration(ProjectFileSystem projectFileSystem, Settings settings) {
        this.projectFileSystem = projectFileSystem;
        this.settings = settings;
    }

    public File getTargetXMLReport() {
        if (this.settings.getBoolean(PROPERTY_GENERATE_XML)) {
            return this.projectFileSystem.resolvePath(PMD_RESULT_XML);
        }
        return null;
    }

    public File dumpXmlRuleSet(String repositoryKey, String rulesXml) {
        try {
            File configurationFile = this.projectFileSystem.writeToWorkingDirectory(rulesXml, repositoryKey + ".xml");
            LOG.info("PMD configuration: " + configurationFile.getAbsolutePath());
            return configurationFile;
        }
        catch (IOException e) {
            throw new SonarException("Fail to save the PMD configuration", (Throwable)e);
        }
    }

    public File dumpXmlReport(Report report) {
        if (!this.settings.getBoolean(PROPERTY_GENERATE_XML)) {
            return null;
        }
        try {
            String reportAsString = PmdConfiguration.reportToString(report);
            File reportFile = this.projectFileSystem.writeToWorkingDirectory(reportAsString, PMD_RESULT_XML);
            LOG.info("PMD output report: " + reportFile.getAbsolutePath());
            return reportFile;
        }
        catch (IOException e) {
            throw new SonarException("Fail to save the PMD report", (Throwable)e);
        }
    }

    private static String reportToString(Report report) throws IOException {
        StringWriter output = new StringWriter();
        XMLRenderer xmlRenderer = new XMLRenderer();
        xmlRenderer.setWriter((Writer)output);
        xmlRenderer.start();
        xmlRenderer.renderFileReport(report);
        xmlRenderer.end();
        return output.toString();
    }
}

