/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import org.sonar.api.BatchExtension;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.java.api.JavaUtils;
import org.sonar.plugins.pmd.PmdConfiguration;
import org.sonar.plugins.pmd.PmdProfileExporter;
import org.sonar.plugins.pmd.PmdTemplate;
import org.sonar.plugins.pmd.PmdVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdExecutor
implements BatchExtension {
    private final Project project;
    private final ProjectFileSystem projectFileSystem;
    private final RulesProfile rulesProfile;
    private final PmdProfileExporter pmdProfileExporter;
    private final PmdConfiguration pmdConfiguration;

    public PmdExecutor(Project project, ProjectFileSystem projectFileSystem, RulesProfile rulesProfile, PmdProfileExporter pmdProfileExporter, PmdConfiguration pmdConfiguration) {
        this.project = project;
        this.projectFileSystem = projectFileSystem;
        this.rulesProfile = rulesProfile;
        this.pmdProfileExporter = pmdProfileExporter;
        this.pmdConfiguration = pmdConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report execute() {
        TimeProfiler profiler = new TimeProfiler().start("Execute PMD " + PmdVersion.getVersion());
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Report report = this.executePmd();
            return report;
        }
        finally {
            Thread.currentThread().setContextClassLoader(initialClassLoader);
            profiler.stop();
        }
    }

    private Report executePmd() {
        Report report = new Report();
        RuleContext context = new RuleContext();
        context.setReport(report);
        PmdTemplate pmdFactory = this.createPmdTemplate();
        this.executeRules(pmdFactory, context, this.projectFileSystem.mainFiles(new String[]{"java"}), "pmd");
        this.executeRules(pmdFactory, context, this.projectFileSystem.testFiles(new String[]{"java"}), "pmd-unit-tests");
        this.pmdConfiguration.dumpXmlReport(report);
        return report;
    }

    public void executeRules(PmdTemplate pmdFactory, RuleContext ruleContext, List<InputFile> files, String repositoryKey) {
        if (files.isEmpty()) {
            return;
        }
        RuleSets rulesets = this.createRulesets(repositoryKey);
        if (rulesets.getAllRules().isEmpty()) {
            return;
        }
        Charset encoding = this.projectFileSystem.getSourceCharset();
        for (InputFile file : files) {
            pmdFactory.process(file, encoding, rulesets, ruleContext);
        }
    }

    private RuleSets createRulesets(String repositoryKey) {
        String rulesXml = this.pmdProfileExporter.exportProfile(repositoryKey, this.rulesProfile);
        this.pmdConfiguration.dumpXmlRuleSet(repositoryKey, rulesXml);
        return new RuleSets(PmdExecutor.readRuleSet(rulesXml));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuleSet readRuleSet(String rulesXml) {
        RuleSet ruleSet;
        ByteArrayInputStream rulesInput = null;
        try {
            rulesInput = new ByteArrayInputStream(rulesXml.getBytes());
            ruleSet = new RuleSetFactory().createRuleSet((InputStream)rulesInput);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(rulesInput);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)rulesInput);
        return ruleSet;
    }

    @VisibleForTesting
    PmdTemplate createPmdTemplate() {
        return new PmdTemplate(JavaUtils.getSourceVersion((Project)this.project));
    }
}

