/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.Report;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.XmlParserException;
import org.sonar.plugins.pmd.PmdExecutor;
import org.sonar.plugins.pmd.PmdViolationToRuleViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdSensor
implements Sensor {
    private final RulesProfile profile;
    private final PmdExecutor executor;
    private final PmdViolationToRuleViolation pmdViolationToRuleViolation;

    public PmdSensor(RulesProfile profile, PmdExecutor executor, PmdViolationToRuleViolation pmdViolationToRuleViolation) {
        this.profile = profile;
        this.executor = executor;
        this.pmdViolationToRuleViolation = pmdViolationToRuleViolation;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !project.getFileSystem().mainFiles(new String[]{"java"}).isEmpty() && !this.profile.getActiveRulesByRepository("pmd").isEmpty() || !project.getFileSystem().testFiles(new String[]{"java"}).isEmpty() && !this.profile.getActiveRulesByRepository("pmd-unit-tests").isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        try {
            Report report = this.executor.execute();
            this.reportViolations(report.iterator(), context);
        }
        catch (Exception e) {
            throw new XmlParserException((Throwable)e);
        }
    }

    private void reportViolations(Iterator<IRuleViolation> violations, SensorContext context) {
        while (violations.hasNext()) {
            IRuleViolation pmdViolation = violations.next();
            Violation violation = this.pmdViolationToRuleViolation.toViolation(pmdViolation, context);
            if (null == violation) continue;
            context.saveViolation(violation);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

