/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.InputFile;
import org.sonar.api.utils.SonarException;

public class PmdTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(PmdTemplate.class);
    private static final Map<String, String> JAVA_VERSIONS = ImmutableMap.of((Object)"1.1", (Object)"1.3", (Object)"1.2", (Object)"1.3", (Object)"5", (Object)"1.5", (Object)"6", (Object)"1.6");
    private final PMD pmd;

    public PmdTemplate(String javaVersion) {
        this(new PMD());
        PmdTemplate.setJavaVersion(this.pmd, javaVersion);
    }

    @VisibleForTesting
    PmdTemplate(PMD pmd) {
        this.pmd = pmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InputFile inputFile, Charset encoding, RuleSets rulesets, RuleContext ruleContext) {
        File file = inputFile.getFile();
        ruleContext.setSourceCodeFilename(file.getAbsolutePath());
        InputStream inputStream = null;
        try {
            inputStream = inputFile.getInputStream();
            this.pmd.processFile(inputStream, encoding.displayName(), rulesets, ruleContext);
        }
        catch (PMDException e) {
            LOG.error("Fail to execute PMD. Following file is ignored: " + file, e.getCause());
        }
        catch (Exception e) {
            LOG.error("Fail to execute PMD. Following file is ignored: " + file, (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }

    @VisibleForTesting
    static void setJavaVersion(PMD pmd, String javaVersion) {
        String version = PmdTemplate.normalize(javaVersion);
        SourceType sourceType = SourceType.getSourceTypeForId((String)("java " + version));
        if (sourceType == null) {
            throw new SonarException("Unsupported Java version for PMD: " + version);
        }
        LOG.info("Java version: " + version);
        pmd.setJavaVersion(sourceType);
    }

    private static String normalize(String version) {
        return (String)Functions.forMap(JAVA_VERSIONS, (Object)version).apply((Object)version);
    }
}

