/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pmd;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import net.sourceforge.pmd.IRuleViolation;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;

public class PmdViolationToRuleViolation
implements BatchExtension {
    private final ProjectFileSystem projectFileSystem;
    private final RuleFinder ruleFinder;

    public PmdViolationToRuleViolation(ProjectFileSystem projectFileSystem, RuleFinder ruleFinder) {
        this.projectFileSystem = projectFileSystem;
        this.ruleFinder = ruleFinder;
    }

    public Violation toViolation(IRuleViolation pmdViolation, SensorContext context) {
        Resource resource = this.findResourceFor(pmdViolation);
        if (context.getResource(resource) == null) {
            return null;
        }
        Rule rule = this.findRuleFor(pmdViolation);
        if (rule == null) {
            return null;
        }
        int lineId = pmdViolation.getBeginLine();
        String message = pmdViolation.getDescription();
        return Violation.create((Rule)rule, (Resource)resource).setLineId(Integer.valueOf(lineId)).setMessage(message);
    }

    private Resource findResourceFor(IRuleViolation violation) {
        ImmutableList allSources = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)this.projectFileSystem.getSourceDirs(), (Iterable)this.projectFileSystem.getTestDirs()));
        return JavaFile.fromAbsolutePath((String)violation.getFilename(), (List)allSources, (boolean)true);
    }

    private Rule findRuleFor(IRuleViolation violation) {
        String ruleKey = violation.getRule().getName();
        Rule rule = this.ruleFinder.findByKey("pmd", ruleKey);
        if (rule != null) {
            return rule;
        }
        return this.ruleFinder.findByKey("pmd-unit-tests", ruleKey);
    }
}

