/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProcessor;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.effects.NiftyRenderDeviceProxy;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.RenderStates;
import de.lessvoid.nifty.tools.TimeProvider;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class EffectManager {
    private Notify notify;
    private Map<EffectEventId, EffectProcessor> effectProcessor = new Hashtable<EffectEventId, EffectProcessor>();
    private List<EffectProcessor> effectProcessorList;
    private Falloff hoverFalloff;
    private NiftyRenderDeviceProxy renderDeviceProxy = new NiftyRenderDeviceProxy();
    private String alternateKey;
    private boolean isEmpty = true;
    private RenderPhase renderPhasePre = new RenderPhasePre();
    private RenderPhase renderPhasePost = new RenderPhasePost();
    private RenderPhase renderPhaseOverlay = new RenderPhaseOverlay();
    private RenderStates savedRenderStates = new RenderStates();

    public EffectManager(Notify notify) {
        this.notify = notify;
        this.alternateKey = null;
        this.effectProcessor.put(EffectEventId.onStartScreen, new EffectProcessor(new NotifyAdapter(EffectEventId.onStartScreen, notify), false));
        this.effectProcessor.put(EffectEventId.onEndScreen, new EffectProcessor(new NotifyAdapter(EffectEventId.onEndScreen, notify), true));
        this.effectProcessor.put(EffectEventId.onFocus, new EffectProcessor(new NotifyAdapter(EffectEventId.onFocus, notify), true));
        this.effectProcessor.put(EffectEventId.onGetFocus, new EffectProcessor(new NotifyAdapter(EffectEventId.onGetFocus, notify), false));
        this.effectProcessor.put(EffectEventId.onLostFocus, new EffectProcessor(new NotifyAdapter(EffectEventId.onLostFocus, notify), false));
        this.effectProcessor.put(EffectEventId.onClick, new EffectProcessor(new NotifyAdapter(EffectEventId.onClick, notify), false));
        this.effectProcessor.put(EffectEventId.onHover, new EffectProcessor(new NotifyAdapter(EffectEventId.onHover, notify), true));
        this.effectProcessor.put(EffectEventId.onStartHover, new EffectProcessor(new NotifyAdapter(EffectEventId.onStartHover, notify), false));
        this.effectProcessor.put(EffectEventId.onEndHover, new EffectProcessor(new NotifyAdapter(EffectEventId.onEndHover, notify), false));
        this.effectProcessor.put(EffectEventId.onActive, new EffectProcessor(new NotifyAdapter(EffectEventId.onActive, notify), true));
        this.effectProcessor.put(EffectEventId.onCustom, new EffectProcessor(new NotifyAdapter(EffectEventId.onCustom, notify), false));
        this.effectProcessor.put(EffectEventId.onShow, new EffectProcessor(new NotifyAdapter(EffectEventId.onShow, notify), false));
        this.effectProcessor.put(EffectEventId.onHide, new EffectProcessor(new NotifyAdapter(EffectEventId.onHide, notify), true));
        this.effectProcessor.put(EffectEventId.onEnabled, new EffectProcessor(new NotifyAdapter(EffectEventId.onEnabled, notify), true));
        this.effectProcessor.put(EffectEventId.onDisabled, new EffectProcessor(new NotifyAdapter(EffectEventId.onDisabled, notify), true));
        this.effectProcessorList = new ArrayList<EffectProcessor>(this.effectProcessor.values());
    }

    public void registerEffect(EffectEventId id, Effect e) {
        this.effectProcessor.get((Object)id).registerEffect(e);
        this.isEmpty = false;
    }

    public void startEffect(EffectEventId id, Element w, TimeProvider time, EndNotify listener) {
        this.effectProcessor.get((Object)id).activate(listener, this.alternateKey, null);
    }

    public void startEffect(EffectEventId id, Element w, TimeProvider time, EndNotify listener, String customKey) {
        this.effectProcessor.get((Object)id).activate(listener, this.alternateKey, customKey);
    }

    public void stopEffect(EffectEventId effectId) {
        this.effectProcessor.get((Object)effectId).setActive(false);
    }

    public void begin(NiftyRenderEngine renderDevice, Element element) {
        this.savedRenderStates.addAll();
        for (int i = 0; i < this.effectProcessorList.size(); ++i) {
            EffectProcessor processor = this.effectProcessorList.get(i);
            processor.getRenderStatesToSave(this.renderDeviceProxy);
            this.savedRenderStates.removeAll(this.renderDeviceProxy.getStates());
        }
        renderDevice.saveState(this.savedRenderStates);
    }

    public void end(NiftyRenderEngine renderDevice) {
        renderDevice.restoreState();
    }

    private void render(Element element, NiftyRenderEngine renderEngine, RenderPhase phase) {
        phase.render(this.effectProcessor.get((Object)EffectEventId.onShow), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onHide), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onStartScreen), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onEndScreen), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onCustom), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onActive), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onHover), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onStartHover), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onEndHover), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onFocus), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onLostFocus), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onGetFocus), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onClick), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onEnabled), renderEngine);
        phase.render(this.effectProcessor.get((Object)EffectEventId.onDisabled), renderEngine);
    }

    public void renderPre(NiftyRenderEngine renderEngine, Element element) {
        this.render(element, renderEngine, this.renderPhasePre);
    }

    public void renderPost(NiftyRenderEngine renderEngine, Element element) {
        this.render(element, renderEngine, this.renderPhasePost);
    }

    public void renderOverlay(NiftyRenderEngine renderEngine, Element element) {
        this.render(element, renderEngine, this.renderPhaseOverlay);
    }

    public void handleHover(Element element, int x, int y) {
        EffectProcessor processor = this.effectProcessor.get((Object)EffectEventId.onHover);
        processor.processHover(x, y);
    }

    public void handleHoverStartAndEnd(Element element, int x, int y) {
        EffectProcessor processor = this.effectProcessor.get((Object)EffectEventId.onStartHover);
        processor.processStartHover(x, y);
        processor = this.effectProcessor.get((Object)EffectEventId.onEndHover);
        processor.processEndHover(x, y);
    }

    public void handleHoverDeactivate(Element element, int x, int y) {
        EffectProcessor processor = this.effectProcessor.get((Object)EffectEventId.onHover);
        processor.processHoverDeactivate(x, y);
    }

    public final boolean isActive(EffectEventId effectEventId) {
        return this.effectProcessor.get((Object)effectEventId).isActive();
    }

    public void reset() {
        this.effectProcessor.get((Object)EffectEventId.onStartScreen).reset();
        this.effectProcessor.get((Object)EffectEventId.onEndScreen).reset();
        this.effectProcessor.get((Object)EffectEventId.onShow).reset();
        this.effectProcessor.get((Object)EffectEventId.onHide).reset();
    }

    public void resetAll() {
        this.effectProcessor.get((Object)EffectEventId.onStartScreen).reset();
        this.effectProcessor.get((Object)EffectEventId.onEndScreen).reset();
        this.effectProcessor.get((Object)EffectEventId.onShow).reset();
        this.effectProcessor.get((Object)EffectEventId.onHide).reset();
        this.effectProcessor.get((Object)EffectEventId.onCustom).reset();
        this.effectProcessor.get((Object)EffectEventId.onHover).reset();
        this.effectProcessor.get((Object)EffectEventId.onStartHover).reset();
        this.effectProcessor.get((Object)EffectEventId.onEndHover).reset();
        this.effectProcessor.get((Object)EffectEventId.onFocus).reset();
        this.effectProcessor.get((Object)EffectEventId.onLostFocus).reset();
        this.effectProcessor.get((Object)EffectEventId.onGetFocus).reset();
        this.effectProcessor.get((Object)EffectEventId.onClick).reset();
    }

    public void resetForHide() {
        this.effectProcessor.get((Object)EffectEventId.onStartScreen).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onEndScreen).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onShow).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onHide).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onCustom).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onHover).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onStartHover).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onEndHover).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onFocus).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onLostFocus).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onGetFocus).saveActiveNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onClick).saveActiveNeverStopRenderingEffects();
    }

    public void restoreForShow() {
        this.effectProcessor.get((Object)EffectEventId.onStartScreen).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onEndScreen).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onShow).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onHide).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onCustom).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onHover).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onStartHover).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onEndHover).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onFocus).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onLostFocus).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onGetFocus).restoreNeverStopRenderingEffects();
        this.effectProcessor.get((Object)EffectEventId.onClick).restoreNeverStopRenderingEffects();
    }

    public void resetSingleEffect(EffectEventId effectEventId) {
        this.effectProcessor.get((Object)effectEventId).reset();
    }

    public void resetSingleEffect(EffectEventId effectEventId, String customKey) {
        this.effectProcessor.get((Object)effectEventId).reset(customKey);
    }

    public void setAlternateKey(String newAlternateKey) {
        this.alternateKey = newAlternateKey;
    }

    public String getStateString(String offset) {
        StringBuffer data = new StringBuffer();
        int activeProcessors = 0;
        for (EffectEventId eventId : this.effectProcessor.keySet()) {
            EffectProcessor processor = this.effectProcessor.get((Object)eventId);
            if (!processor.isActive()) continue;
            ++activeProcessors;
            data.append(offset);
            data.append("  {" + eventId.toString() + "} ");
            data.append(processor.getStateString());
        }
        if (activeProcessors == 0) {
            return offset + "{}";
        }
        return data.toString();
    }

    public void setFalloff(Falloff newFalloff) {
        this.hoverFalloff = newFalloff;
    }

    public Falloff getFalloff() {
        return this.hoverFalloff;
    }

    public void removeAllEffects() {
        for (int i = 0; i < this.effectProcessorList.size(); ++i) {
            EffectProcessor processor = this.effectProcessorList.get(i);
            processor.removeAllEffects();
        }
        this.isEmpty = true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public <T extends EffectImpl> List<Effect> getEffects(EffectEventId effectEventId, Class<T> requestedClass) {
        return this.effectProcessor.get((Object)effectEventId).getEffects(requestedClass);
    }

    private class NotifyAdapter
    implements EffectProcessor.Notify {
        private Notify notify;
        private EffectEventId eventId;

        public NotifyAdapter(EffectEventId eventId, Notify notify) {
            this.eventId = eventId;
            this.notify = notify;
        }

        @Override
        public void effectProcessorStateChanged(boolean active) {
            this.notify.effectStateChanged(this.eventId, active);
        }
    }

    public static interface Notify {
        public void effectStateChanged(EffectEventId var1, boolean var2);
    }

    private static final class RenderPhaseOverlay
    implements RenderPhase {
        private RenderPhaseOverlay() {
        }

        @Override
        public void render(EffectProcessor processor, NiftyRenderEngine renderEngine) {
            processor.renderOverlay(renderEngine);
        }
    }

    private static final class RenderPhasePost
    implements RenderPhase {
        private RenderPhasePost() {
        }

        @Override
        public void render(EffectProcessor processor, NiftyRenderEngine renderEngine) {
            processor.renderPost(renderEngine);
        }
    }

    private static final class RenderPhasePre
    implements RenderPhase {
        private RenderPhasePre() {
        }

        @Override
        public void render(EffectProcessor processor, NiftyRenderEngine renderEngine) {
            processor.renderPre(renderEngine);
        }
    }

    static interface RenderPhase {
        public void render(EffectProcessor var1, NiftyRenderEngine var2);
    }
}

